/*
   コンパイル：
      clang -framework Foundation main.m
   実行:
     ./a.out
*/

// わかりやすくするため、チェックはいいかげんですので悪しからずご了承ください
#import <Foundation/Foundation.h>

@interface Stack : NSObject
- (id) init;
- (void) push: (NSString*) elm;
- (NSString *)pop;
@end

@implementation Stack {
  NSMutableArray *stack;
}
- (id) init {
  self = [super init];
  if (self) {
    stack = [NSMutableArray new];
  }
  return self;
}
- (void) push: elem {
  NSLog(@"プッシュ：%@", elem);
  [stack addObject: elem];
}

- (NSString *)pop {
  NSString * returnVal = [stack lastObject];
  NSLog(@"ポップ：%@", returnVal);
  [stack removeLastObject];
  return returnVal;
}

@end


int main(int argc, const char * argv[]) {

  Stack* myStack1 = [Stack new]; // Stackのインスタンスを生成し、初期化
  [myStack1 push: @"★"];
  [myStack1 push: @"▲"];

  NSString* item = [myStack1 pop];
  NSLog(@"ポップした要素=%@", item);

  Stack* myStack2 = [Stack new]; // もうひとつStackのインスタンスを生成し、初期化
  [myStack2 push: @"No. 1"];
  [myStack2 push: @"No. 2"];
  [myStack2 push: @"No. 3"];

  item = [myStack2 pop];
  NSLog(@"ポップした要素=%@", item);

  [myStack2 push: @"No. 4"];
  item = [myStack2 pop];
  NSLog(@"ポップした要素=%@", item);

  item = [myStack2 pop];
  NSLog(@"ポップした要素=%@", item);

  item = [myStack2 pop];
  NSLog(@"ポップした要素=%@", item);

  item = [myStack1 pop];
  NSLog(@"ポップした要素=%@", item);

  return 0;

}
