/*
   コンパイル：
      clang -framework Foundation main.m
   実行:
     ./a.out
*/

// わかりやすくするため、チェックはいいかげんですので悪しからずご了承ください
#import <Foundation/Foundation.h>

@interface Stack : NSObject
- (id) init;
- (void) push: (NSString*) elm;
- (NSString *)pop;
@end

@implementation Stack {
  NSMutableArray *stack;
}
- (id) init {
  self = [super init];
  if (self) {
    stack = [NSMutableArray new];
  }
  return self;
}
- (void) push: elem {
  NSLog(@"プッシュ：%@", elem);
  [stack addObject: elem];
}

- (NSString *)pop {
  NSString * returnVal = [stack lastObject];
  NSLog(@"ポップ：%@", returnVal);
  [stack removeLastObject];
  return returnVal;
}

@end


int main(int argc, const char * argv[]) {

  Stack* myStack1 = [Stack new]; // Stackのインスタンスを生成し、初期化
  Stack* myStack2 = myStack1;
  [myStack1 push: @"Hello"];
  [myStack1 push: @"World"];
  NSString* s = [myStack2 pop];

  NSLog(@"s=%@", s);
  NSString* s2 = [myStack2 pop];
  NSLog(@"s=%@; s2=%@", s, s2);

  return 0;

}

