/*
   コンパイル：
      clang -framework Foundation main.m
*/

#import <Foundation/Foundation.h>

NSInteger sortByLastCharacter(id string1, id string2, void* context) {
  NSString* s1 = (NSString*) string1;
  NSString* s2 = (NSString*) string2;
  NSString* string1end = [s1 substringFromIndex:[s1 length] - 1];
  NSString* string2end = [s2 substringFromIndex:[s2 length] - 1];
  return [string1end compare:string2end];
}

int main(int argc, const char * argv[]) {

  NSArray* friends = @[@"イヌ", @"サル", @"キジ", @"モモタロウ"];

  //  NSArray* friendsSorted = 
  //     [friends sortedArrayUsingFunction:sortByCharacters context:nil];

  NSArray* friendsSortedByBlock
    = [friends sortedArrayUsingComparator: ^(id obj1, id obj2) {
      NSString* s1 = (NSString*) obj1;
      NSString* s2 = (NSString*) obj2;
      NSString* string1end = [s1 substringFromIndex:[s1 length] - 1];
      NSString* string2end = [s2 substringFromIndex:[s2 length] - 1];
      return [string1end compare:string2end];
    }];

  NSArray* friendsSortedByFunc = 
    [friends sortedArrayUsingFunction:sortByLastCharacter context:nil];

  NSLog(@"コードブロック: %@, %@, %@, %@\n", friendsSortedByBlock[0], friendsSortedByBlock[1],
	friendsSortedByBlock[2], friendsSortedByBlock[3]);
  NSLog(@"関数: %@, %@, %@, %@\n", friendsSortedByFunc[0], friendsSortedByFunc[1],
	friendsSortedByFunc[2], friendsSortedByFunc[3]);
}
