//
//  main.m
//  example-05-072-property2
//


#import <Foundation/Foundation.h>

@interface Dog : NSObject
- (void) setNumber: (int) n;
- (int) number;
@end

@implementation Dog {
  int number;
}

// プロパティを利用するには、セッターメソッドとゲッターメソッドの定義は必須
- (void) setNumber: (int) n {
  self->number = n;
}
- (int) number {
  return self->number;
}
@end

int main(int argc, const char * argv[]) {
  
  Dog* fido = [Dog new];
  id fidoId = fido;
  
  [fidoId setNumber: 5]; // これは可能。id型だが実体はDog*
  NSLog(@"1. number=%d\n", [fidoId number]);
  fidoId.number = 42; //  これはエラーになってしまってコンパイルできない
  
  return 0;
}

