#import <Foundation/Foundation.h>

@interface Dog : NSObject {
}

- (NSString*) speak;
- (NSString*) bark;
@end

@implementation Dog
- (NSString*) bark { 
  return @"ワン！　ワン！";
} 
- (NSString*) speak {
  return [self bark];
}
@end

@interface NoisyDog : Dog {
}
@end

@implementation NoisyDog
- (NSString*) bark {
  return [NSString stringWithFormat: @"%@ %@", [super bark], [super bark]];
}
@end


@interface Basenji : Dog {
}
@end

@implementation Basenji
- (NSString*) bark {
  return @""; // バセンジは吠えないので、空文字列を返す
}
@end

int main(int argc, char * argv[]) {
  Dog* d = [[Dog alloc] init];
  NSLog(@"普通の犬が吠える：%@", [d speak]);
    
  Basenji* b = [[Basenji alloc] init];
  NSLog(@"バセンジが吠える：%@", [b speak]);
    
  NoisyDog* n = [[NoisyDog alloc] init];
  NSLog(@"騒がしい犬が吠える：%@", [n speak]);
}
