/*
   コンパイル：
      clang -framework Foundation main.m
*/

#import <Foundation/Foundation.h>

@interface Dog : NSObject
- (void) setNumber: (int) n;
- (int) number;
@end

@implementation Dog {
  int number;
}

// プロパティを利用するには、セッターメソッドとゲッターメソッドの定義は必須
- (void) setNumber: (int) n {
  self->number = n;
}
- (int) number {
  return self->number;
}
@end

int main(int argc, const char * argv[]) {

  Dog* fido = [Dog new];

  fido.number = 42;  // プロパティ
  NSLog(@"1. number=%d\n", [fido number]); // ゲッターメソッド
  NSLog(@"2. number=%d\n", [[fido valueForKey: @"number"] intValue]); // キー値コーディング
  NSLog(@"3. number=%d\n", fido.number); // プロパティ
  // 以上の3つは、同じ値になる

  return 0;
}
