/*
   コンパイル：
      clang -framework Foundation main.m
*/

#import <Foundation/Foundation.h>

@interface Dog : NSObject
- (id) initWithNumber: (int) n;
- (id) init;
- (void) setNumber: (int) n;
- (int) number;
@end

@implementation Dog {
  int number;
}

- (id) initWithNumber: (int) n {
  self = [super init];
  if (self) {
    self->number = n;
  }
  return self;
}

- (id) init {
  return [self initWithNumber: -9999];
}

// プロパティを利用するには、セッターメソッドとゲッターメソッドの定義は必須
- (void) setNumber: (int) n {
  self->number = n;
}
- (int) number {
  return self->number;
}
@end

int main(int argc, const char * argv[]) {

  Dog* fido = [[Dog alloc] initWithNumber: 42];
  int n = [fido number]; // n は42になっている
  NSLog(@"number=%d\n", fido.number);
  NSLog(@"n=%d\n", n);

  fido.number = 44;
  NSLog(@"fido.number=%d\n", fido.number);

  Dog* dog2 = [Dog new];
  n = [dog2 number]; 
  NSLog(@"n=%d\n", n);

  return 0;
}
