static const char* CubemapVertexShader = STRINGIFY(

attribute vec4 Position;
attribute vec3 Normal;

uniform mat4 Projection;
uniform mat4 Modelview;
uniform mat3 Model;
uniform vec3  EyePosition;

varying vec3 ReflectDir;

void main(void)
{
    gl_Position = Projection * Modelview * Position;
    
    // オブジェクト空間での視線方向を計算する
    mediump vec3 eyeDir = normalize(Position.xyz - EyePosition);

    // 法線ベクトルに対して視線方向ベクトルを反転し、ワールド空間に変換する
    ReflectDir = Model * reflect(eyeDir, Normal);
//	ReflectDir = Model * Position.xyz; // この行は消去せず、単位球でテストするときに使う。
}
);
