/******************************************************************************

 @File         PVRTMathTable.h

 @Title        

 @Copyright    Copyright (C)  Imagination Technologies Limited.

 @Platform     ANSI compatible

 @Description  Trigonometric lookup table. This is a low-precision lookup table
               that should only be used for trigonometric operations that do not
               require high precision.

******************************************************************************/
#ifndef _TRIGTABLE
#define _TRIGTABLE

/* Define number of entries in table */
#define NUM_ENTRIES 1024

/* Fixed-point lookup tables for all trigonometric functions */
const int cos_val[]={
0x00010000,0x0000FFFE,0x0000FFFB,0x0000FFF4,0x0000FFEC,0x0000FFE1,0x0000FFD3,0x0000FFC3,0x0000FFB0,0x0000FF9B,
0x0000FF84,0x0000FF6A,0x0000FF4E,0x0000FF2F,0x0000FF0D,0x0000FEEA,0x0000FEC3,0x0000FE9B,0x0000FE6F,0x0000FE42,
0x0000FE12,0x0000FDDF,0x0000FDAA,0x0000FD73,0x0000FD39,0x0000FCFC,0x0000FCBE,0x0000FC7C,0x0000FC39,0x0000FBF3,
0x0000FBAA,0x0000FB5F,0x0000FB12,0x0000FAC2,0x0000FA70,0x0000FA1B,0x0000F9C4,0x0000F96B,0x0000F90F,0x0000F8B0,
0x0000F850,0x0000F7ED,0x0000F787,0x0000F71F,0x0000F6B5,0x0000F648,0x0000F5D9,0x0000F568,0x0000F4F4,0x0000F47E,
0x0000F405,0x0000F38B,0x0000F30D,0x0000F28E,0x0000F20C,0x0000F188,0x0000F101,0x0000F078,0x0000EFED,0x0000EF5F,
0x0000EED0,0x0000EE3D,0x0000EDA9,0x0000ED12,0x0000EC79,0x0000EBDE,0x0000EB40,0x0000EAA0,0x0000E9FE,0x0000E95A,
0x0000E8B3,0x0000E80A,0x0000E75F,0x0000E6B2,0x0000E602,0x0000E550,0x0000E49C,0x0000E3E6,0x0000E32E,0x0000E273,
0x0000E1B6,0x0000E0F7,0x0000E036,0x0000DF73,0x0000DEAD,0x0000DDE6,0x0000DD1C,0x0000DC50,0x0000DB82,0x0000DAB2,
0x0000D9DF,0x0000D90B,0x0000D834,0x0000D75C,0x0000D681,0x0000D5A5,0x0000D4C6,0x0000D3E5,0x0000D302,0x0000D21D,
0x0000D136,0x0000D04D,0x0000CF62,0x0000CE75,0x0000CD86,0x0000CC95,0x0000CBA2,0x0000CAAD,0x0000C9B6,0x0000C8BE,
0x0000C7C3,0x0000C6C6,0x0000C5C8,0x0000C4C7,0x0000C3C5,0x0000C2C0,0x0000C1BA,0x0000C0B2,0x0000BFA8,0x0000BE9C,
0x0000BD8F,0x0000BC7F,0x0000BB6E,0x0000BA5B,0x0000B946,0x0000B82F,0x0000B717,0x0000B5FD,0x0000B4E1,0x0000B3C3,
0x0000B2A4,0x0000B183,0x0000B060,0x0000AF3B,0x0000AE15,0x0000ACED,0x0000ABC3,0x0000AA98,0x0000A96B,0x0000A83C,
0x0000A70C,0x0000A5DA,0x0000A4A7,0x0000A372,0x0000A23B,0x0000A103,0x00009FC9,0x00009E8E,0x00009D51,0x00009C13,
0x00009AD3,0x00009992,0x0000984F,0x0000970B,0x000095C5,0x0000947E,0x00009336,0x000091EB,0x000090A0,0x00008F53,
0x00008E05,0x00008CB5,0x00008B65,0x00008A12,0x000088BF,0x0000876A,0x00008613,0x000084BC,0x00008363,0x00008209,
0x000080AE,0x00007F51,0x00007DF3,0x00007C94,0x00007B34,0x000079D3,0x00007870,0x0000770C,0x000075A7,0x00007441,
0x000072DA,0x00007172,0x00007008,0x00006E9E,0x00006D32,0x00006BC6,0x00006A58,0x000068E9,0x0000677A,0x00006609,
0x00006498,0x00006325,0x000061B1,0x0000603D,0x00005EC7,0x00005D51,0x00005BDA,0x00005A62,0x000058E8,0x0000576F,
0x000055F4,0x00005478,0x000052FC,0x0000517F,0x00005001,0x00004E82,0x00004D03,0x00004B82,0x00004A01,0x00004880,
0x000046FD,0x0000457A,0x000043F6,0x00004272,0x000040ED,0x00003F67,0x00003DE1,0x00003C5A,0x00003AD3,0x0000394B,
0x000037C2,0x00003639,0x000034AF,0x00003325,0x0000319B,0x0000300F,0x00002E84,0x00002CF8,0x00002B6B,0x000029DE,
0x00002851,0x000026C3,0x00002535,0x000023A7,0x00002218,0x00002089,0x00001EFA,0x00001D6A,0x00001BDA,0x00001A4A,
0x000018B9,0x00001729,0x00001598,0x00001406,0x00001275,0x000010E3,0x00000F52,0x00000DC0,0x00000C2E,0x00000A9C,
0x00000909,0x00000777,0x000005E5,0x00000452,0x000002C0,0x0000012D,0xFFFFFF9C,0xFFFFFE09,0xFFFFFC77,0xFFFFFAE4,
0xFFFFF952,0xFFFFF7C0,0xFFFFF62D,0xFFFFF49B,0xFFFFF309,0xFFFFF177,0xFFFFEFE5,0xFFFFEE54,0xFFFFECC2,0xFFFFEB31,
0xFFFFE9A0,0xFFFFE80F,0xFFFFE67E,0xFFFFE4EE,0xFFFFE35E,0xFFFFE1CE,0xFFFFE03F,0xFFFFDEAF,0xFFFFDD20,0xFFFFDB92,
0xFFFFDA04,0xFFFFD876,0xFFFFD6E8,0xFFFFD55B,0xFFFFD3CE,0xFFFFD242,0xFFFFD0B6,0xFFFFCF2B,0xFFFFCDA0,0xFFFFCC16,
0xFFFFCA8C,0xFFFFC902,0xFFFFC77A,0xFFFFC5F1,0xFFFFC469,0xFFFFC2E2,0xFFFFC15C,0xFFFFBFD6,0xFFFFBE50,0xFFFFBCCC,
0xFFFFBB48,0xFFFFB9C4,0xFFFFB841,0xFFFFB6BF,0xFFFFB53E,0xFFFFB3BD,0xFFFFB23E,0xFFFFB0BE,0xFFFFAF40,0xFFFFADC3,
0xFFFFAC46,0xFFFFAACA,0xFFFFA94F,0xFFFFA7D4,0xFFFFA65B,0xFFFFA4E2,0xFFFFA36B,0xFFFFA1F4,0xFFFFA07E,0xFFFF9F09,
0xFFFF9D95,0xFFFF9C22,0xFFFF9AB0,0xFFFF993E,0xFFFF97CE,0xFFFF965F,0xFFFF94F1,0xFFFF9384,0xFFFF9218,0xFFFF90AD,
0xFFFF8F43,0xFFFF8DDA,0xFFFF8C72,0xFFFF8B0C,0xFFFF89A6,0xFFFF8842,0xFFFF86DF,0xFFFF857D,0xFFFF841C,0xFFFF82BC,
0xFFFF815E,0xFFFF8000,0xFFFF7EA5,0xFFFF7D4A,0xFFFF7BF0,0xFFFF7A98,0xFFFF7941,0xFFFF77EC,0xFFFF7697,0xFFFF7544,
0xFFFF73F3,0xFFFF72A3,0xFFFF7154,0xFFFF7006,0xFFFF6EBA,0xFFFF6D6F,0xFFFF6C26,0xFFFF6ADE,0xFFFF6998,0xFFFF6853,
0xFFFF670F,0xFFFF65CD,0xFFFF648D,0xFFFF634E,0xFFFF6210,0xFFFF60D4,0xFFFF5F99,0xFFFF5E61,0xFFFF5D29,0xFFFF5BF3,
0xFFFF5ABF,0xFFFF598D,0xFFFF585C,0xFFFF572C,0xFFFF55FE,0xFFFF54D2,0xFFFF53A8,0xFFFF527F,0xFFFF5158,0xFFFF5032,
0xFFFF4F0F,0xFFFF4DED,0xFFFF4CCC,0xFFFF4BAE,0xFFFF4A91,0xFFFF4976,0xFFFF485D,0xFFFF4745,0xFFFF462F,0xFFFF451B,
0xFFFF4409,0xFFFF42F9,0xFFFF41EA,0xFFFF40DD,0xFFFF3FD3,0xFFFF3ECA,0xFFFF3DC3,0xFFFF3CBD,0xFFFF3BBA,0xFFFF3AB8,
0xFFFF39B9,0xFFFF38BB,0xFFFF37C0,0xFFFF36C6,0xFFFF35CE,0xFFFF34D8,0xFFFF33E4,0xFFFF32F2,0xFFFF3202,0xFFFF3114,
0xFFFF3028,0xFFFF2F3E,0xFFFF2E56,0xFFFF2D70,0xFFFF2C8C,0xFFFF2BAA,0xFFFF2ACB,0xFFFF29ED,0xFFFF2911,0xFFFF2838,
0xFFFF2760,0xFFFF268B,0xFFFF25B7,0xFFFF24E6,0xFFFF2417,0xFFFF234A,0xFFFF227F,0xFFFF21B6,0xFFFF20F0,0xFFFF202B,
0xFFFF1F69,0xFFFF1EA9,0xFFFF1DEB,0xFFFF1D2F,0xFFFF1C76,0xFFFF1BBE,0xFFFF1B09,0xFFFF1A56,0xFFFF19A6,0xFFFF18F7,
0xFFFF184B,0xFFFF17A1,0xFFFF16F9,0xFFFF1654,0xFFFF15B0,0xFFFF150F,0xFFFF1471,0xFFFF13D4,0xFFFF133A,0xFFFF12A2,
0xFFFF120C,0xFFFF1179,0xFFFF10E8,0xFFFF1059,0xFFFF0FCD,0xFFFF0F43,0xFFFF0EBB,0xFFFF0E36,0xFFFF0DB3,0xFFFF0D32,
0xFFFF0CB4,0xFFFF0C38,0xFFFF0BBE,0xFFFF0B47,0xFFFF0AD2,0xFFFF0A5F,0xFFFF09EF,0xFFFF0981,0xFFFF0916,0xFFFF08AD,
0xFFFF0846,0xFFFF07E2,0xFFFF0780,0xFFFF0720,0xFFFF06C3,0xFFFF0668,0xFFFF0610,0xFFFF05BA,0xFFFF0567,0xFFFF0516,
0xFFFF04C7,0xFFFF047B,0xFFFF0431,0xFFFF03EA,0xFFFF03A5,0xFFFF0363,0xFFFF0323,0xFFFF02E5,0xFFFF02AA,0xFFFF0271,
0xFFFF023B,0xFFFF0207,0xFFFF01D6,0xFFFF01A7,0xFFFF017B,0xFFFF0151,0xFFFF0129,0xFFFF0104,0xFFFF00E2,0xFFFF00C2,
0xFFFF00A4,0xFFFF0089,0xFFFF0070,0xFFFF005A,0xFFFF0046,0xFFFF0035,0xFFFF0026,0xFFFF001A,0xFFFF0010,0xFFFF0008,
0xFFFF0003,0xFFFF0001,0xFFFF0001,0xFFFF0003,0xFFFF0008,0xFFFF0010,0xFFFF001A,0xFFFF0026,0xFFFF0035,0xFFFF0046,
0xFFFF005A,0xFFFF0070,0xFFFF0089,0xFFFF00A4,0xFFFF00C2,0xFFFF00E2,0xFFFF0104,0xFFFF0129,0xFFFF0151,0xFFFF017B,
0xFFFF01A7,0xFFFF01D6,0xFFFF0207,0xFFFF023B,0xFFFF0271,0xFFFF02AA,0xFFFF02E5,0xFFFF0323,0xFFFF0363,0xFFFF03A5,
0xFFFF03EA,0xFFFF0431,0xFFFF047B,0xFFFF04C7,0xFFFF0516,0xFFFF0567,0xFFFF05BA,0xFFFF0610,0xFFFF0668,0xFFFF06C3,
0xFFFF0720,0xFFFF0780,0xFFFF07E2,0xFFFF0846,0xFFFF08AD,0xFFFF0916,0xFFFF0981,0xFFFF09EF,0xFFFF0A5F,0xFFFF0AD2,
0xFFFF0B47,0xFFFF0BBE,0xFFFF0C38,0xFFFF0CB4,0xFFFF0D32,0xFFFF0DB3,0xFFFF0E36,0xFFFF0EBB,0xFFFF0F43,0xFFFF0FCD,
0xFFFF1059,0xFFFF10E8,0xFFFF1179,0xFFFF120C,0xFFFF12A2,0xFFFF133A,0xFFFF13D4,0xFFFF1471,0xFFFF150F,0xFFFF15B0,
0xFFFF1654,0xFFFF16F9,0xFFFF17A1,0xFFFF184B,0xFFFF18F7,0xFFFF19A6,0xFFFF1A56,0xFFFF1B09,0xFFFF1BBE,0xFFFF1C76,
0xFFFF1D2F,0xFFFF1DEB,0xFFFF1EA9,0xFFFF1F69,0xFFFF202B,0xFFFF20F0,0xFFFF21B6,0xFFFF227F,0xFFFF234A,0xFFFF2417,
0xFFFF24E6,0xFFFF25B7,0xFFFF268B,0xFFFF2760,0xFFFF2838,0xFFFF2911,0xFFFF29ED,0xFFFF2ACB,0xFFFF2BAA,0xFFFF2C8C,
0xFFFF2D70,0xFFFF2E56,0xFFFF2F3E,0xFFFF3028,0xFFFF3114,0xFFFF3202,0xFFFF32F2,0xFFFF33E4,0xFFFF34D8,0xFFFF35CE,
0xFFFF36C6,0xFFFF37C0,0xFFFF38BB,0xFFFF39B9,0xFFFF3AB8,0xFFFF3BBA,0xFFFF3CBD,0xFFFF3DC3,0xFFFF3ECA,0xFFFF3FD3,
0xFFFF40DD,0xFFFF41EA,0xFFFF42F9,0xFFFF4409,0xFFFF451B,0xFFFF462F,0xFFFF4745,0xFFFF485D,0xFFFF4976,0xFFFF4A91,
0xFFFF4BAE,0xFFFF4CCC,0xFFFF4DED,0xFFFF4F0F,0xFFFF5032,0xFFFF5158,0xFFFF527F,0xFFFF53A8,0xFFFF54D2,0xFFFF55FE,
0xFFFF572C,0xFFFF585C,0xFFFF598D,0xFFFF5ABF,0xFFFF5BF3,0xFFFF5D29,0xFFFF5E61,0xFFFF5F99,0xFFFF60D4,0xFFFF6210,
0xFFFF634E,0xFFFF648D,0xFFFF65CD,0xFFFF670F,0xFFFF6853,0xFFFF6998,0xFFFF6ADE,0xFFFF6C26,0xFFFF6D6F,0xFFFF6EBA,
0xFFFF7006,0xFFFF7154,0xFFFF72A3,0xFFFF73F3,0xFFFF7544,0xFFFF7697,0xFFFF77EC,0xFFFF7941,0xFFFF7A98,0xFFFF7BF0,
0xFFFF7D4A,0xFFFF7EA5,0xFFFF8001,0xFFFF815E,0xFFFF82BC,0xFFFF841C,0xFFFF857D,0xFFFF86DF,0xFFFF8842,0xFFFF89A6,
0xFFFF8B0C,0xFFFF8C72,0xFFFF8DDA,0xFFFF8F43,0xFFFF90AD,0xFFFF9218,0xFFFF9384,0xFFFF94F1,0xFFFF965F,0xFFFF97CE,
0xFFFF993E,0xFFFF9AB0,0xFFFF9C22,0xFFFF9D95,0xFFFF9F09,0xFFFFA07E,0xFFFFA1F4,0xFFFFA36B,0xFFFFA4E2,0xFFFFA65B,
0xFFFFA7D4,0xFFFFA94F,0xFFFFAACA,0xFFFFAC46,0xFFFFADC3,0xFFFFAF40,0xFFFFB0BE,0xFFFFB23E,0xFFFFB3BD,0xFFFFB53E,
0xFFFFB6BF,0xFFFFB841,0xFFFFB9C4,0xFFFFBB48,0xFFFFBCCC,0xFFFFBE50,0xFFFFBFD6,0xFFFFC15C,0xFFFFC2E2,0xFFFFC469,
0xFFFFC5F1,0xFFFFC77A,0xFFFFC902,0xFFFFCA8C,0xFFFFCC16,0xFFFFCDA0,0xFFFFCF2B,0xFFFFD0B6,0xFFFFD242,0xFFFFD3CE,
0xFFFFD55B,0xFFFFD6E8,0xFFFFD876,0xFFFFDA04,0xFFFFDB92,0xFFFFDD20,0xFFFFDEAF,0xFFFFE03F,0xFFFFE1CE,0xFFFFE35E,
0xFFFFE4EE,0xFFFFE67E,0xFFFFE80F,0xFFFFE9A0,0xFFFFEB31,0xFFFFECC2,0xFFFFEE54,0xFFFFEFE5,0xFFFFF177,0xFFFFF309,
0xFFFFF49B,0xFFFFF62D,0xFFFFF7C0,0xFFFFF952,0xFFFFFAE4,0xFFFFFC77,0xFFFFFE09,0xFFFFFF9C,0x0000012D,0x000002C0,
0x00000452,0x000005E5,0x00000777,0x00000909,0x00000A9C,0x00000C2E,0x00000DC0,0x00000F52,0x000010E3,0x00001275,
0x00001406,0x00001598,0x00001729,0x000018B9,0x00001A4A,0x00001BDA,0x00001D6A,0x00001EFA,0x00002089,0x00002218,
0x000023A7,0x00002535,0x000026C3,0x00002851,0x000029DE,0x00002B6B,0x00002CF8,0x00002E84,0x0000300F,0x0000319B,
0x00003325,0x000034AF,0x00003639,0x000037C2,0x0000394B,0x00003AD3,0x00003C5A,0x00003DE1,0x00003F67,0x000040ED,
0x00004272,0x000043F6,0x0000457A,0x000046FD,0x00004880,0x00004A01,0x00004B82,0x00004D03,0x00004E82,0x00005001,
0x0000517F,0x000052FC,0x00005478,0x000055F4,0x0000576F,0x000058E9,0x00005A62,0x00005BDA,0x00005D51,0x00005EC7,
0x0000603D,0x000061B1,0x00006325,0x00006498,0x00006609,0x0000677A,0x000068EA,0x00006A58,0x00006BC6,0x00006D32,
0x00006E9E,0x00007008,0x00007172,0x000072DA,0x00007441,0x000075A7,0x0000770C,0x00007870,0x000079D3,0x00007B34,
0x00007C94,0x00007DF3,0x00007F51,0x000080AE,0x00008209,0x00008363,0x000084BC,0x00008613,0x0000876A,0x000088BF,
0x00008A12,0x00008B65,0x00008CB5,0x00008E05,0x00008F53,0x000090A0,0x000091EC,0x00009336,0x0000947E,0x000095C5,
0x0000970B,0x0000984F,0x00009992,0x00009AD3,0x00009C13,0x00009D51,0x00009E8E,0x00009FC9,0x0000A103,0x0000A23B,
0x0000A372,0x0000A4A7,0x0000A5DA,0x0000A70C,0x0000A83C,0x0000A96B,0x0000AA98,0x0000ABC3,0x0000ACED,0x0000AE15,
0x0000AF3B,0x0000B060,0x0000B183,0x0000B2A4,0x0000B3C3,0x0000B4E1,0x0000B5FD,0x0000B717,0x0000B82F,0x0000B946,
0x0000BA5B,0x0000BB6E,0x0000BC7F,0x0000BD8F,0x0000BE9C,0x0000BFA8,0x0000C0B2,0x0000C1BA,0x0000C2C0,0x0000C3C5,
0x0000C4C7,0x0000C5C8,0x0000C6C6,0x0000C7C3,0x0000C8BE,0x0000C9B6,0x0000CAAD,0x0000CBA2,0x0000CC95,0x0000CD86,
0x0000CE75,0x0000CF62,0x0000D04D,0x0000D136,0x0000D21D,0x0000D302,0x0000D3E5,0x0000D4C6,0x0000D5A5,0x0000D681,
0x0000D75C,0x0000D834,0x0000D90B,0x0000D9DF,0x0000DAB2,0x0000DB82,0x0000DC50,0x0000DD1C,0x0000DDE6,0x0000DEAD,
0x0000DF73,0x0000E036,0x0000E0F7,0x0000E1B6,0x0000E273,0x0000E32E,0x0000E3E6,0x0000E49C,0x0000E550,0x0000E602,
0x0000E6B2,0x0000E75F,0x0000E80A,0x0000E8B3,0x0000E95A,0x0000E9FE,0x0000EAA0,0x0000EB40,0x0000EBDE,0x0000EC79,
0x0000ED12,0x0000EDA9,0x0000EE3D,0x0000EED0,0x0000EF5F,0x0000EFED,0x0000F078,0x0000F101,0x0000F188,0x0000F20C,
0x0000F28E,0x0000F30D,0x0000F38B,0x0000F405,0x0000F47E,0x0000F4F4,0x0000F568,0x0000F5D9,0x0000F648,0x0000F6B5,
0x0000F71F,0x0000F787,0x0000F7ED,0x0000F850,0x0000F8B0,0x0000F90F,0x0000F96B,0x0000F9C4,0x0000FA1B,0x0000FA70,
0x0000FAC2,0x0000FB12,0x0000FB5F,0x0000FBAA,0x0000FBF3,0x0000FC39,0x0000FC7C,0x0000FCBE,0x0000FCFC,0x0000FD39,
0x0000FD73,0x0000FDAA,0x0000FDDF,0x0000FE12,0x0000FE42,0x0000FE6F,0x0000FE9B,0x0000FEC3,0x0000FEEA,0x0000FF0D,
0x0000FF2F,0x0000FF4E,0x0000FF6A,0x0000FF84,0x0000FF9B,0x0000FFB0,0x0000FFC3,0x0000FFD3,0x0000FFE1,0x0000FFEC,
0x0000FFF4,0x0000FFFB,0x0000FFFE,0x00010000,
0};
const int sin_val[]={
0x00000000,0x00000192,0x00000325,0x000004B7,0x00000649,0x000007DC,0x0000096E,0x00000B00,0x00000C92,0x00000E24,
0x00000FB6,0x00001148,0x000012D9,0x0000146B,0x000015FC,0x0000178D,0x0000191D,0x00001AAE,0x00001C3E,0x00001DCE,
0x00001F5E,0x000020ED,0x0000227C,0x0000240B,0x00002599,0x00002727,0x000028B5,0x00002A42,0x00002BCF,0x00002D5B,
0x00002EE7,0x00003072,0x000031FD,0x00003388,0x00003512,0x0000369B,0x00003824,0x000039AD,0x00003B35,0x00003CBC,
0x00003E43,0x00003FC9,0x0000414E,0x000042D3,0x00004457,0x000045DB,0x0000475E,0x000048E0,0x00004A62,0x00004BE2,
0x00004D62,0x00004EE2,0x00005060,0x000051DE,0x0000535B,0x000054D7,0x00005653,0x000057CD,0x00005947,0x00005AC0,
0x00005C38,0x00005DAF,0x00005F25,0x0000609A,0x0000620E,0x00006382,0x000064F4,0x00006665,0x000067D6,0x00006945,
0x00006AB4,0x00006C21,0x00006D8D,0x00006EF9,0x00007063,0x000071CC,0x00007334,0x0000749B,0x00007601,0x00007765,
0x000078C9,0x00007A2B,0x00007B8C,0x00007CEC,0x00007E4B,0x00007FA8,0x00008105,0x00008260,0x000083B9,0x00008512,
0x00008669,0x000087BF,0x00008914,0x00008A67,0x00008BB9,0x00008D09,0x00008E59,0x00008FA7,0x000090F3,0x0000923E,
0x00009388,0x000094D0,0x00009617,0x0000975C,0x000098A0,0x000099E2,0x00009B23,0x00009C63,0x00009DA1,0x00009EDD,
0x0000A018,0x0000A151,0x0000A289,0x0000A3BF,0x0000A4F4,0x0000A627,0x0000A758,0x0000A888,0x0000A9B6,0x0000AAE3,
0x0000AC0E,0x0000AD37,0x0000AE5E,0x0000AF84,0x0000B0A9,0x0000B1CB,0x0000B2EC,0x0000B40B,0x0000B528,0x0000B644,
0x0000B75D,0x0000B875,0x0000B98C,0x0000BAA0,0x0000BBB3,0x0000BCC3,0x0000BDD2,0x0000BEE0,0x0000BFEB,0x0000C0F4,
0x0000C1FC,0x0000C302,0x0000C405,0x0000C507,0x0000C607,0x0000C706,0x0000C802,0x0000C8FC,0x0000C9F4,0x0000CAEB,
0x0000CBDF,0x0000CCD2,0x0000CDC2,0x0000CEB1,0x0000CF9D,0x0000D088,0x0000D170,0x0000D256,0x0000D33B,0x0000D41D,
0x0000D4FE,0x0000D5DC,0x0000D6B8,0x0000D792,0x0000D86A,0x0000D940,0x0000DA14,0x0000DAE6,0x0000DBB6,0x0000DC83,
0x0000DD4E,0x0000DE18,0x0000DEDF,0x0000DFA4,0x0000E067,0x0000E127,0x0000E1E6,0x0000E2A2,0x0000E35C,0x0000E414,
0x0000E4CA,0x0000E57D,0x0000E62E,0x0000E6DD,0x0000E78A,0x0000E835,0x0000E8DD,0x0000E983,0x0000EA27,0x0000EAC9,
0x0000EB68,0x0000EC05,0x0000ECA0,0x0000ED38,0x0000EDCE,0x0000EE62,0x0000EEF4,0x0000EF83,0x0000F010,0x0000F09B,
0x0000F123,0x0000F1A9,0x0000F22D,0x0000F2AE,0x0000F32D,0x0000F3AA,0x0000F424,0x0000F49C,0x0000F511,0x0000F584,
0x0000F5F5,0x0000F664,0x0000F6D0,0x0000F739,0x0000F7A1,0x0000F806,0x0000F868,0x0000F8C8,0x0000F926,0x0000F981,
0x0000F9DA,0x0000FA30,0x0000FA85,0x0000FAD6,0x0000FB25,0x0000FB72,0x0000FBBD,0x0000FC04,0x0000FC4A,0x0000FC8D,
0x0000FCCE,0x0000FD0C,0x0000FD47,0x0000FD81,0x0000FDB8,0x0000FDEC,0x0000FE1E,0x0000FE4D,0x0000FE7A,0x0000FEA5,
0x0000FECD,0x0000FEF3,0x0000FF16,0x0000FF37,0x0000FF55,0x0000FF71,0x0000FF8A,0x0000FFA1,0x0000FFB5,0x0000FFC7,
0x0000FFD7,0x0000FFE4,0x0000FFEE,0x0000FFF6,0x0000FFFC,0x0000FFFF,0x0000FFFF,0x0000FFFE,0x0000FFF9,0x0000FFF2,
0x0000FFE9,0x0000FFDD,0x0000FFCF,0x0000FFBF,0x0000FFAB,0x0000FF96,0x0000FF7E,0x0000FF63,0x0000FF46,0x0000FF27,
0x0000FF05,0x0000FEE0,0x0000FEB9,0x0000FE90,0x0000FE64,0x0000FE36,0x0000FE05,0x0000FDD2,0x0000FD9D,0x0000FD64,
0x0000FD2A,0x0000FCED,0x0000FCAE,0x0000FC6C,0x0000FC27,0x0000FBE1,0x0000FB98,0x0000FB4C,0x0000FAFE,0x0000FAAE,
0x0000FA5B,0x0000FA06,0x0000F9AE,0x0000F954,0x0000F8F7,0x0000F898,0x0000F837,0x0000F7D3,0x0000F76D,0x0000F705,
0x0000F69A,0x0000F62D,0x0000F5BD,0x0000F54B,0x0000F4D7,0x0000F460,0x0000F3E7,0x0000F36B,0x0000F2EE,0x0000F26E,
0x0000F1EB,0x0000F166,0x0000F0DF,0x0000F056,0x0000EFCA,0x0000EF3C,0x0000EEAB,0x0000EE19,0x0000ED84,0x0000ECEC,
0x0000EC53,0x0000EBB7,0x0000EB19,0x0000EA78,0x0000E9D5,0x0000E930,0x0000E889,0x0000E7E0,0x0000E734,0x0000E686,
0x0000E5D6,0x0000E524,0x0000E46F,0x0000E3B8,0x0000E2FF,0x0000E244,0x0000E187,0x0000E0C7,0x0000E005,0x0000DF42,
0x0000DE7C,0x0000DDB3,0x0000DCE9,0x0000DC1D,0x0000DB4E,0x0000DA7D,0x0000D9AA,0x0000D8D6,0x0000D7FF,0x0000D725,
0x0000D64A,0x0000D56D,0x0000D48E,0x0000D3AC,0x0000D2C9,0x0000D1E4,0x0000D0FC,0x0000D013,0x0000CF27,0x0000CE3A,
0x0000CD4A,0x0000CC59,0x0000CB65,0x0000CA70,0x0000C978,0x0000C87F,0x0000C784,0x0000C687,0x0000C588,0x0000C487,
0x0000C384,0x0000C27F,0x0000C178,0x0000C070,0x0000BF65,0x0000BE59,0x0000BD4B,0x0000BC3B,0x0000BB29,0x0000BA16,
0x0000B901,0x0000B7EA,0x0000B6D1,0x0000B5B6,0x0000B49A,0x0000B37B,0x0000B25C,0x0000B13A,0x0000B017,0x0000AEF2,
0x0000ADCB,0x0000ACA3,0x0000AB78,0x0000AA4D,0x0000A91F,0x0000A7F0,0x0000A6C0,0x0000A58E,0x0000A45A,0x0000A324,
0x0000A1ED,0x0000A0B5,0x00009F7B,0x00009E3F,0x00009D02,0x00009BC3,0x00009A83,0x00009941,0x000097FE,0x000096BA,
0x00009574,0x0000942C,0x000092E3,0x00009199,0x0000904D,0x00008F00,0x00008DB1,0x00008C61,0x00008B10,0x000089BD,
0x0000886A,0x00008714,0x000085BE,0x00008466,0x0000830D,0x000081B2,0x00008057,0x00007EFA,0x00007D9C,0x00007C3C,
0x00007ADC,0x0000797A,0x00007817,0x000076B3,0x0000754E,0x000073E7,0x00007280,0x00007117,0x00006FAE,0x00006E43,
0x00006CD7,0x00006B6A,0x000069FD,0x0000688E,0x0000671E,0x000065AD,0x0000643B,0x000062C8,0x00006154,0x00005FDF,
0x00005E6A,0x00005CF3,0x00005B7C,0x00005A03,0x0000588A,0x00005710,0x00005595,0x00005419,0x0000529D,0x0000511F,
0x00004FA1,0x00004E22,0x00004CA3,0x00004B22,0x000049A1,0x0000481F,0x0000469D,0x00004519,0x00004395,0x00004211,
0x0000408C,0x00003F06,0x00003D7F,0x00003BF8,0x00003A71,0x000038E9,0x00003760,0x000035D7,0x0000344D,0x000032C3,
0x00003138,0x00002FAD,0x00002E21,0x00002C95,0x00002B08,0x0000297B,0x000027EE,0x00002660,0x000024D2,0x00002343,
0x000021B4,0x00002025,0x00001E96,0x00001D06,0x00001B76,0x000019E6,0x00001855,0x000016C4,0x00001533,0x000013A2,
0x00001211,0x0000107F,0x00000EED,0x00000D5B,0x00000BC9,0x00000A37,0x000008A5,0x00000713,0x00000580,0x000003EE,
0x0000025B,0x000000C9,0xFFFFFF37,0xFFFFFDA5,0xFFFFFC12,0xFFFFFA80,0xFFFFF8ED,0xFFFFF75B,0xFFFFF5C9,0xFFFFF437,
0xFFFFF2A5,0xFFFFF113,0xFFFFEF81,0xFFFFEDEF,0xFFFFEC5E,0xFFFFEACD,0xFFFFE93C,0xFFFFE7AB,0xFFFFE61A,0xFFFFE48A,
0xFFFFE2FA,0xFFFFE16A,0xFFFFDFDB,0xFFFFDE4C,0xFFFFDCBD,0xFFFFDB2E,0xFFFFD9A0,0xFFFFD812,0xFFFFD685,0xFFFFD4F8,
0xFFFFD36B,0xFFFFD1DF,0xFFFFD053,0xFFFFCEC8,0xFFFFCD3D,0xFFFFCBB3,0xFFFFCA29,0xFFFFC8A0,0xFFFFC717,0xFFFFC58F,
0xFFFFC408,0xFFFFC281,0xFFFFC0FA,0xFFFFBF74,0xFFFFBDEF,0xFFFFBC6B,0xFFFFBAE7,0xFFFFB963,0xFFFFB7E1,0xFFFFB65F,
0xFFFFB4DE,0xFFFFB35D,0xFFFFB1DE,0xFFFFB05F,0xFFFFAEE1,0xFFFFAD63,0xFFFFABE7,0xFFFFAA6B,0xFFFFA8F0,0xFFFFA776,
0xFFFFA5FD,0xFFFFA484,0xFFFFA30D,0xFFFFA196,0xFFFFA020,0xFFFF9EAC,0xFFFF9D38,0xFFFF9BC5,0xFFFF9A53,0xFFFF98E2,
0xFFFF9772,0xFFFF9603,0xFFFF9496,0xFFFF9329,0xFFFF91BD,0xFFFF9052,0xFFFF8EE9,0xFFFF8D80,0xFFFF8C18,0xFFFF8AB2,
0xFFFF894D,0xFFFF87E9,0xFFFF8686,0xFFFF8524,0xFFFF83C4,0xFFFF8264,0xFFFF8106,0xFFFF7FA9,0xFFFF7E4E,0xFFFF7CF3,
0xFFFF7B9A,0xFFFF7A42,0xFFFF78EC,0xFFFF7796,0xFFFF7643,0xFFFF74F0,0xFFFF739F,0xFFFF724F,0xFFFF7100,0xFFFF6FB3,
0xFFFF6E67,0xFFFF6D1D,0xFFFF6BD4,0xFFFF6A8C,0xFFFF6946,0xFFFF6802,0xFFFF66BF,0xFFFF657D,0xFFFF643D,0xFFFF62FE,
0xFFFF61C1,0xFFFF6085,0xFFFF5F4B,0xFFFF5E13,0xFFFF5CDC,0xFFFF5BA6,0xFFFF5A72,0xFFFF5940,0xFFFF5810,0xFFFF56E1,
0xFFFF55B3,0xFFFF5487,0xFFFF535D,0xFFFF5235,0xFFFF510E,0xFFFF4FE9,0xFFFF4EC6,0xFFFF4DA4,0xFFFF4C85,0xFFFF4B66,
0xFFFF4A4A,0xFFFF492F,0xFFFF4816,0xFFFF46FF,0xFFFF45EA,0xFFFF44D7,0xFFFF43C5,0xFFFF42B5,0xFFFF41A7,0xFFFF409B,
0xFFFF3F90,0xFFFF3E88,0xFFFF3D81,0xFFFF3C7C,0xFFFF3B79,0xFFFF3A78,0xFFFF3979,0xFFFF387C,0xFFFF3781,0xFFFF3688,
0xFFFF3590,0xFFFF349B,0xFFFF33A7,0xFFFF32B6,0xFFFF31C6,0xFFFF30D9,0xFFFF2FED,0xFFFF2F04,0xFFFF2E1C,0xFFFF2D37,
0xFFFF2C54,0xFFFF2B72,0xFFFF2A93,0xFFFF29B6,0xFFFF28DB,0xFFFF2801,0xFFFF272A,0xFFFF2656,0xFFFF2583,0xFFFF24B2,
0xFFFF23E3,0xFFFF2317,0xFFFF224D,0xFFFF2184,0xFFFF20BE,0xFFFF1FFB,0xFFFF1F39,0xFFFF1E79,0xFFFF1DBC,0xFFFF1D01,
0xFFFF1C48,0xFFFF1B91,0xFFFF1ADC,0xFFFF1A2A,0xFFFF197A,0xFFFF18CC,0xFFFF1820,0xFFFF1777,0xFFFF16D0,0xFFFF162B,
0xFFFF1588,0xFFFF14E7,0xFFFF1449,0xFFFF13AD,0xFFFF1314,0xFFFF127C,0xFFFF11E7,0xFFFF1155,0xFFFF10C4,0xFFFF1036,
0xFFFF0FAA,0xFFFF0F21,0xFFFF0E9A,0xFFFF0E15,0xFFFF0D92,0xFFFF0D12,0xFFFF0C95,0xFFFF0C19,0xFFFF0BA0,0xFFFF0B29,
0xFFFF0AB5,0xFFFF0A43,0xFFFF09D3,0xFFFF0966,0xFFFF08FB,0xFFFF0893,0xFFFF082D,0xFFFF07C9,0xFFFF0768,0xFFFF0709,
0xFFFF06AC,0xFFFF0652,0xFFFF05FA,0xFFFF05A5,0xFFFF0552,0xFFFF0502,0xFFFF04B4,0xFFFF0468,0xFFFF041F,0xFFFF03D9,
0xFFFF0394,0xFFFF0352,0xFFFF0313,0xFFFF02D6,0xFFFF029C,0xFFFF0263,0xFFFF022E,0xFFFF01FB,0xFFFF01CA,0xFFFF019C,
0xFFFF0170,0xFFFF0147,0xFFFF0120,0xFFFF00FB,0xFFFF00D9,0xFFFF00BA,0xFFFF009D,0xFFFF0082,0xFFFF006A,0xFFFF0055,
0xFFFF0041,0xFFFF0031,0xFFFF0023,0xFFFF0017,0xFFFF000E,0xFFFF0007,0xFFFF0002,0xFFFF0001,0xFFFF0001,0xFFFF0004,
0xFFFF000A,0xFFFF0012,0xFFFF001C,0xFFFF0029,0xFFFF0039,0xFFFF004B,0xFFFF005F,0xFFFF0076,0xFFFF008F,0xFFFF00AB,
0xFFFF00C9,0xFFFF00EA,0xFFFF010D,0xFFFF0133,0xFFFF015B,0xFFFF0186,0xFFFF01B3,0xFFFF01E2,0xFFFF0214,0xFFFF0248,
0xFFFF027F,0xFFFF02B9,0xFFFF02F4,0xFFFF0332,0xFFFF0373,0xFFFF03B6,0xFFFF03FC,0xFFFF0443,0xFFFF048E,0xFFFF04DB,
0xFFFF052A,0xFFFF057B,0xFFFF05D0,0xFFFF0626,0xFFFF067F,0xFFFF06DA,0xFFFF0738,0xFFFF0798,0xFFFF07FA,0xFFFF085F,
0xFFFF08C7,0xFFFF0930,0xFFFF099C,0xFFFF0A0B,0xFFFF0A7C,0xFFFF0AEF,0xFFFF0B64,0xFFFF0BDC,0xFFFF0C56,0xFFFF0CD3,
0xFFFF0D52,0xFFFF0DD3,0xFFFF0E57,0xFFFF0EDD,0xFFFF0F65,0xFFFF0FF0,0xFFFF107D,0xFFFF110C,0xFFFF119E,0xFFFF1232,
0xFFFF12C8,0xFFFF1360,0xFFFF13FB,0xFFFF1498,0xFFFF1537,0xFFFF15D9,0xFFFF167D,0xFFFF1723,0xFFFF17CB,0xFFFF1876,
0xFFFF1923,0xFFFF19D2,0xFFFF1A83,0xFFFF1B36,0xFFFF1BEC,0xFFFF1CA4,0xFFFF1D5E,0xFFFF1E1A,0xFFFF1ED9,0xFFFF1F99,
0xFFFF205C,0xFFFF2121,0xFFFF21E8,0xFFFF22B2,0xFFFF237D,0xFFFF244A,0xFFFF251A,0xFFFF25EC,0xFFFF26C0,0xFFFF2796,
0xFFFF286E,0xFFFF2948,0xFFFF2A24,0xFFFF2B02,0xFFFF2BE3,0xFFFF2CC5,0xFFFF2DAA,0xFFFF2E90,0xFFFF2F78,0xFFFF3063,
0xFFFF314F,0xFFFF323E,0xFFFF332E,0xFFFF3421,0xFFFF3515,0xFFFF360C,0xFFFF3704,0xFFFF37FE,0xFFFF38FA,0xFFFF39F9,
0xFFFF3AF9,0xFFFF3BFB,0xFFFF3CFE,0xFFFF3E04,0xFFFF3F0C,0xFFFF4015,0xFFFF4121,0xFFFF422E,0xFFFF433D,0xFFFF444D,
0xFFFF4560,0xFFFF4674,0xFFFF478B,0xFFFF48A3,0xFFFF49BC,0xFFFF4AD8,0xFFFF4BF5,0xFFFF4D14,0xFFFF4E35,0xFFFF4F57,
0xFFFF507C,0xFFFF51A2,0xFFFF52C9,0xFFFF53F2,0xFFFF551D,0xFFFF564A,0xFFFF5778,0xFFFF58A8,0xFFFF59D9,0xFFFF5B0C,
0xFFFF5C41,0xFFFF5D77,0xFFFF5EAF,0xFFFF5FE8,0xFFFF6123,0xFFFF625F,0xFFFF639D,0xFFFF64DD,0xFFFF661E,0xFFFF6760,
0xFFFF68A4,0xFFFF69E9,0xFFFF6B30,0xFFFF6C78,0xFFFF6DC2,0xFFFF6F0D,0xFFFF7059,0xFFFF71A7,0xFFFF72F7,0xFFFF7447,
0xFFFF7599,0xFFFF76EC,0xFFFF7841,0xFFFF7997,0xFFFF7AEE,0xFFFF7C47,0xFFFF7DA0,0xFFFF7EFB,0xFFFF8058,0xFFFF81B5,
0xFFFF8314,0xFFFF8474,0xFFFF85D5,0xFFFF8737,0xFFFF889B,0xFFFF89FF,0xFFFF8B65,0xFFFF8CCC,0xFFFF8E34,0xFFFF8F9D,
0xFFFF9107,0xFFFF9273,0xFFFF93DF,0xFFFF954C,0xFFFF96BB,0xFFFF982A,0xFFFF999B,0xFFFF9B0C,0xFFFF9C7E,0xFFFF9DF2,
0xFFFF9F66,0xFFFFA0DB,0xFFFFA251,0xFFFFA3C8,0xFFFFA540,0xFFFFA6B9,0xFFFFA833,0xFFFFA9AD,0xFFFFAB29,0xFFFFACA5,
0xFFFFAE22,0xFFFFAFA0,0xFFFFB11E,0xFFFFB29E,0xFFFFB41E,0xFFFFB59E,0xFFFFB720,0xFFFFB8A2,0xFFFFBA25,0xFFFFBBA9,
0xFFFFBD2D,0xFFFFBEB2,0xFFFFC037,0xFFFFC1BD,0xFFFFC344,0xFFFFC4CB,0xFFFFC653,0xFFFFC7DC,0xFFFFC965,0xFFFFCAEE,
0xFFFFCC78,0xFFFFCE03,0xFFFFCF8E,0xFFFFD119,0xFFFFD2A5,0xFFFFD432,0xFFFFD5BE,0xFFFFD74B,0xFFFFD8D9,0xFFFFDA67,
0xFFFFDBF5,0xFFFFDD84,0xFFFFDF13,0xFFFFE0A2,0xFFFFE232,0xFFFFE3C2,0xFFFFE552,0xFFFFE6E3,0xFFFFE873,0xFFFFEA04,
0xFFFFEB95,0xFFFFED27,0xFFFFEEB8,0xFFFFF04A,0xFFFFF1DC,0xFFFFF36E,0xFFFFF500,0xFFFFF692,0xFFFFF824,0xFFFFF9B7,
0xFFFFFB49,0xFFFFFCDC,0xFFFFFE6E,0x00000000,
0};
const int tan_val[]={
0x00000000,0x00000192,0x00000325,0x000004B7,0x0000064A,0x000007DD,0x00000970,0x00000B03,0x00000C96,0x00000E2A,
0x00000FBE,0x00001152,0x000012E6,0x0000147B,0x00001611,0x000017A6,0x0000193D,0x00001AD3,0x00001C6A,0x00001E02,
0x00001F9B,0x00002134,0x000022CD,0x00002467,0x00002602,0x0000279E,0x0000293B,0x00002AD8,0x00002C76,0x00002E16,
0x00002FB6,0x00003157,0x000032F8,0x0000349B,0x00003640,0x000037E5,0x0000398B,0x00003B32,0x00003CDB,0x00003E85,
0x00004030,0x000041DD,0x0000438A,0x0000453A,0x000046EA,0x0000489D,0x00004A50,0x00004C05,0x00004DBC,0x00004F75,
0x0000512F,0x000052EB,0x000054A8,0x00005668,0x00005829,0x000059EC,0x00005BB1,0x00005D79,0x00005F42,0x0000610D,
0x000062DB,0x000064AA,0x0000667C,0x00006850,0x00006A27,0x00006C00,0x00006DDB,0x00006FB9,0x0000719A,0x0000737D,
0x00007562,0x0000774B,0x00007936,0x00007B25,0x00007D16,0x00007F0A,0x00008101,0x000082FB,0x000084F9,0x000086FA,
0x000088FE,0x00008B05,0x00008D10,0x00008F1F,0x00009131,0x00009347,0x00009560,0x0000977E,0x0000999F,0x00009BC5,
0x00009DEE,0x0000A01C,0x0000A24E,0x0000A485,0x0000A6C0,0x0000A900,0x0000AB44,0x0000AD8D,0x0000AFDB,0x0000B22E,
0x0000B486,0x0000B6E3,0x0000B946,0x0000BBAE,0x0000BE1C,0x0000C08F,0x0000C308,0x0000C587,0x0000C80D,0x0000CA98,
0x0000CD2A,0x0000CFC2,0x0000D261,0x0000D507,0x0000D7B4,0x0000DA68,0x0000DD23,0x0000DFE5,0x0000E2B0,0x0000E582,
0x0000E85C,0x0000EB3E,0x0000EE29,0x0000F11C,0x0000F418,0x0000F71D,0x0000FA2B,0x0000FD43,0x00010064,0x0001038F,
0x000106C5,0x00010A05,0x00010D4F,0x000110A5,0x00011406,0x00011772,0x00011AEA,0x00011E6E,0x000121FF,0x0001259C,
0x00012947,0x00012CFF,0x000130C5,0x00013499,0x0001387C,0x00013C6E,0x0001406F,0x00014480,0x000148A2,0x00014CD4,
0x00015118,0x0001556D,0x000159D5,0x00015E50,0x000162DE,0x00016780,0x00016C37,0x00017103,0x000175E5,0x00017ADD,
0x00017FED,0x00018515,0x00018A56,0x00018FB1,0x00019526,0x00019AB6,0x0001A063,0x0001A62D,0x0001AC16,0x0001B21E,
0x0001B846,0x0001BE91,0x0001C4FE,0x0001CB8F,0x0001D245,0x0001D923,0x0001E029,0x0001E758,0x0001EEB4,0x0001F63C,
0x0001FDF4,0x000205DD,0x00020DF8,0x00021649,0x00021ED0,0x00022792,0x0002308F,0x000239CC,0x0002434A,0x00024D0C,
0x00025716,0x0002616B,0x00026C0E,0x00027704,0x00028250,0x00028DF6,0x000299FC,0x0002A665,0x0002B338,0x0002C079,
0x0002CE2F,0x0002DC61,0x0002EB14,0x0002FA50,0x00030A1E,0x00031A86,0x00032B90,0x00033D49,0x00034FB9,0x000362ED,
0x000376F3,0x00038BD7,0x0003A1A9,0x0003B87A,0x0003D05D,0x0003E964,0x000403A8,0x00041F3F,0x00043C45,0x00045AD8,
0x00047B19,0x00049D2D,0x0004C13F,0x0004E77C,0x00051018,0x00053B51,0x00056968,0x00059AAA,0x0005CF70,0x0006081D,
0x00064527,0x00068714,0x0006CE83,0x00071C2F,0x000770F1,0x0007CDD3,0x0008340E,0x0008A523,0x000922E6,0x0009AF9F,
0x000A4E23,0x000B0214,0x000BD01E,0x000CBE65,0x000DD524,0x000F1FA6,0x0010ADD8,0x001296EE,0x0014FE1A,0x00181B64,
0x001C4DD6,0x0022446F,0x002B68EF,0x003B333C,0x005D08B5,0x00D915F5,0xFD74C7B8,0xFF7DC061,0xFFB7A479,0xFFCDE8E1,
0xFFD9B2FF,0xFFE0FF8F,0xFFE5F65F,0xFFE98EBE,0xFFEC481E,0xFFEE6AD3,0xFFF022F6,0xFFF18CF1,0xFFF2BBEB,0xFFF3BD3C,
0xFFF49A83,0xFFF55AD6,0xFFF6038E,0xFFF698C6,0xFFF71DB3,0xFFF794DE,0xFFF80051,0xFFF861B4,0xFFF8BA63,0xFFF90B7C,
0xFFF955F0,0xFFF99A89,0xFFF9D9F2,0xFFFA14BE,0xFFFA4B6A,0xFFFA7E62,0xFFFAAE04,0xFFFADAA3,0xFFFB0486,0xFFFB2BEC,
0xFFFB510D,0xFFFB741A,0xFFFB9540,0xFFFBB4A6,0xFFFBD26E,0xFFFBEEB9,0xFFFC09A3,0xFFFC2346,0xFFFC3BB8,0xFFFC530F,
0xFFFC695F,0xFFFC7EB8,0xFFFC932B,0xFFFCA6C6,0xFFFCB997,0xFFFCCBAA,0xFFFCDD0A,0xFFFCEDC2,0xFFFCFDDC,0xFFFD0D60,
0xFFFD1C57,0xFFFD2AC8,0xFFFD38BB,0xFFFD4636,0xFFFD533F,0xFFFD5FDC,0xFFFD6C13,0xFFFD77E9,0xFFFD8361,0xFFFD8E81,
0xFFFD994E,0xFFFDA3C9,0xFFFDADF8,0xFFFDB7DE,0xFFFDC17E,0xFFFDCADB,0xFFFDD3F7,0xFFFDDCD6,0xFFFDE57B,0xFFFDEDE7,
0xFFFDF61C,0xFFFDFE1E,0xFFFE05EE,0xFFFE0D8E,0xFFFE14FF,0xFFFE1C45,0xFFFE235F,0xFFFE2A51,0xFFFE311B,0xFFFE37BF,
0xFFFE3E3D,0xFFFE4499,0xFFFE4AD2,0xFFFE50EA,0xFFFE56E2,0xFFFE5CBB,0xFFFE6277,0xFFFE6816,0xFFFE6D98,0xFFFE7300,
0xFFFE784E,0xFFFE7D82,0xFFFE829E,0xFFFE87A2,0xFFFE8C8F,0xFFFE9166,0xFFFE9627,0xFFFE9AD4,0xFFFE9F6C,0xFFFEA3F0,
0xFFFEA861,0xFFFEACC0,0xFFFEB10C,0xFFFEB547,0xFFFEB971,0xFFFEBD8A,0xFFFEC193,0xFFFEC58D,0xFFFEC977,0xFFFECD53,
0xFFFED120,0xFFFED4DF,0xFFFED890,0xFFFEDC34,0xFFFEDFCB,0xFFFEE355,0xFFFEE6D4,0xFFFEEA46,0xFFFEEDAC,0xFFFEF107,
0xFFFEF457,0xFFFEF79C,0xFFFEFAD7,0xFFFEFE07,0xFFFF012E,0xFFFF044A,0xFFFF075D,0xFFFF0A67,0xFFFF0D67,0xFFFF105F,
0xFFFF134E,0xFFFF1634,0xFFFF1912,0xFFFF1BE8,0xFFFF1EB6,0xFFFF217D,0xFFFF243C,0xFFFF26F3,0xFFFF29A3,0xFFFF2C4D,
0xFFFF2EEF,0xFFFF318B,0xFFFF3420,0xFFFF36AE,0xFFFF3937,0xFFFF3BB9,0xFFFF3E35,0xFFFF40AB,0xFFFF431C,0xFFFF4587,
0xFFFF47EC,0xFFFF4A4C,0xFFFF4CA7,0xFFFF4EFC,0xFFFF514D,0xFFFF5398,0xFFFF55DF,0xFFFF5821,0xFFFF5A5E,0xFFFF5C97,
0xFFFF5ECB,0xFFFF60FB,0xFFFF6327,0xFFFF654E,0xFFFF6772,0xFFFF6991,0xFFFF6BAD,0xFFFF6DC5,0xFFFF6FD9,0xFFFF71E9,
0xFFFF73F6,0xFFFF75FF,0xFFFF7805,0xFFFF7A07,0xFFFF7C06,0xFFFF7E02,0xFFFF7FFB,0xFFFF81F1,0xFFFF83E3,0xFFFF85D3,
0xFFFF87C0,0xFFFF89AA,0xFFFF8B91,0xFFFF8D75,0xFFFF8F57,0xFFFF9136,0xFFFF9313,0xFFFF94ED,0xFFFF96C5,0xFFFF989A,
0xFFFF9A6D,0xFFFF9C3E,0xFFFF9E0C,0xFFFF9FD9,0xFFFFA1A3,0xFFFFA36B,0xFFFFA531,0xFFFFA6F6,0xFFFFA8B8,0xFFFFAA78,
0xFFFFAC37,0xFFFFADF3,0xFFFFAFAE,0xFFFFB168,0xFFFFB31F,0xFFFFB4D5,0xFFFFB68A,0xFFFFB83D,0xFFFFB9EE,0xFFFFBB9E,
0xFFFFBD4D,0xFFFFBEFA,0xFFFFC0A6,0xFFFFC250,0xFFFFC3F9,0xFFFFC5A1,0xFFFFC748,0xFFFFC8EE,0xFFFFCA93,0xFFFFCC36,
0xFFFFCDD9,0xFFFFCF7A,0xFFFFD11B,0xFFFFD2BA,0xFFFFD459,0xFFFFD5F7,0xFFFFD794,0xFFFFD930,0xFFFFDACB,0xFFFFDC66,
0xFFFFDE00,0xFFFFDF99,0xFFFFE132,0xFFFFE2CA,0xFFFFE461,0xFFFFE5F8,0xFFFFE78F,0xFFFFE925,0xFFFFEABA,0xFFFFEC4F,
0xFFFFEDE4,0xFFFFEF78,0xFFFFF10C,0xFFFFF2A0,0xFFFFF433,0xFFFFF5C7,0xFFFFF75A,0xFFFFF8ED,0xFFFFFA7F,0xFFFFFC12,
0xFFFFFDA5,0xFFFFFF37,0x000000C9,0x0000025B,0x000003EE,0x00000581,0x00000713,0x000008A6,0x00000A39,0x00000BCD,
0x00000D60,0x00000EF4,0x00001088,0x0000121C,0x000013B1,0x00001546,0x000016DB,0x00001871,0x00001A08,0x00001B9F,
0x00001D36,0x00001ECE,0x00002067,0x00002200,0x0000239A,0x00002535,0x000026D0,0x0000286C,0x00002A09,0x00002BA7,
0x00002D46,0x00002EE5,0x00003086,0x00003227,0x000033CA,0x0000356D,0x00003712,0x000038B8,0x00003A5F,0x00003C07,
0x00003DB0,0x00003F5A,0x00004106,0x000042B3,0x00004462,0x00004612,0x000047C3,0x00004976,0x00004B2B,0x00004CE1,
0x00004E98,0x00005052,0x0000520D,0x000053C9,0x00005588,0x00005748,0x0000590A,0x00005ACF,0x00005C95,0x00005E5D,
0x00006027,0x000061F4,0x000063C2,0x00006593,0x00006766,0x0000693B,0x00006B13,0x00006CED,0x00006ECA,0x000070A9,
0x0000728B,0x0000746F,0x00007656,0x00007840,0x00007A2D,0x00007C1D,0x00007E0F,0x00008005,0x000081FE,0x000083FA,
0x000085F9,0x000087FB,0x00008A01,0x00008C0A,0x00008E17,0x00009027,0x0000923B,0x00009453,0x0000966F,0x0000988E,
0x00009AB2,0x00009CD9,0x00009F05,0x0000A135,0x0000A369,0x0000A5A2,0x0000A7DF,0x0000AA21,0x0000AC68,0x0000AEB3,
0x0000B104,0x0000B359,0x0000B5B4,0x0000B814,0x0000BA79,0x0000BCE4,0x0000BF55,0x0000C1CB,0x0000C447,0x0000C6C9,
0x0000C952,0x0000CBE0,0x0000CE75,0x0000D111,0x0000D3B3,0x0000D65D,0x0000D90D,0x0000DBC4,0x0000DE83,0x0000E14A,
0x0000E418,0x0000E6EE,0x0000E9CC,0x0000ECB2,0x0000EFA1,0x0000F299,0x0000F599,0x0000F8A3,0x0000FBB6,0x0000FED2,
0x000101F9,0x00010529,0x00010864,0x00010BA9,0x00010EF9,0x00011254,0x000115BA,0x0001192C,0x00011CAB,0x00012035,
0x000123CC,0x00012770,0x00012B21,0x00012EE0,0x000132AD,0x00013689,0x00013A73,0x00013E6D,0x00014276,0x0001468F,
0x00014AB9,0x00014EF4,0x00015340,0x0001579F,0x00015C10,0x00016094,0x0001652C,0x000169D9,0x00016E9A,0x00017371,
0x0001785E,0x00017D62,0x0001827E,0x000187B2,0x00018D00,0x00019268,0x000197EB,0x00019D89,0x0001A345,0x0001A91E,
0x0001AF16,0x0001B52E,0x0001BB67,0x0001C1C3,0x0001C842,0x0001CEE5,0x0001D5AF,0x0001DCA1,0x0001E3BB,0x0001EB01,
0x0001F272,0x0001FA12,0x000201E2,0x000209E4,0x0002121A,0x00021A85,0x0002232A,0x00022C09,0x00023526,0x00023E82,
0x00024822,0x00025208,0x00025C37,0x000266B2,0x0002717F,0x00027C9F,0x00028818,0x000293ED,0x0002A024,0x0002ACC1,
0x0002B9CA,0x0002C746,0x0002D538,0x0002E3A9,0x0002F2A0,0x00030224,0x0003123E,0x000322F6,0x00033456,0x00034669,
0x0003593A,0x00036CD5,0x00038148,0x000396A1,0x0003ACF1,0x0003C448,0x0003DCBB,0x0003F65D,0x00041147,0x00042D92,
0x00044B5B,0x00046AC1,0x00048BE6,0x0004AEF4,0x0004D414,0x0004FB7B,0x0005255D,0x000551FC,0x0005819E,0x0005B497,
0x0005EB42,0x0006260E,0x00066578,0x0006AA11,0x0006F485,0x0007459E,0x00079E4D,0x0007FFAF,0x00086B23,0x0008E24D,
0x0009673B,0x0009FC72,0x000AA52C,0x000B6581,0x000C42C6,0x000D441A,0x000E730F,0x000FDD0F,0x0011952E,0x0013B7E9,
0x00167144,0x001A09AE,0x001F006D,0x00264D12,0x00321715,0x00485BC3,0x0082416B,0x028B4B44,0xFF26ED97,0xFFA2F76A,
0xFFC4CD07,0xFFD49718,0xFFDDBBA8,0xFFE3B22D,0xFFE7E4A3,0xFFEB01E4,0xFFED6915,0xFFEF5230,0xFFF0E05D,0xFFF22AE1,
0xFFF3419C,0xFFF42FE5,0xFFF4FDEC,0xFFF5B1DF,0xFFF65062,0xFFF6DD1B,0xFFF75ADD,0xFFF7CBF2,0xFFF8322F,0xFFF88F0F,
0xFFF8E3D3,0xFFF9317D,0xFFF978ED,0xFFF9BADA,0xFFF9F7E4,0xFFFA3090,0xFFFA6556,0xFFFA9698,0xFFFAC4B0,0xFFFAEFE7,
0xFFFB1885,0xFFFB3EC2,0xFFFB62D3,0xFFFB84E8,0xFFFBA529,0xFFFBC3BC,0xFFFBE0C1,0xFFFBFC59,0xFFFC169C,0xFFFC2FA4,
0xFFFC4786,0xFFFC5E57,0xFFFC742A,0xFFFC890D,0xFFFC9D13,0xFFFCB047,0xFFFCC2B8,0xFFFCD470,0xFFFCE57B,0xFFFCF5E2,
0xFFFD05B0,0xFFFD14EC,0xFFFD23A0,0xFFFD31D1,0xFFFD3F87,0xFFFD4CC8,0xFFFD599B,0xFFFD6604,0xFFFD720A,0xFFFD7DB0,
0xFFFD88FC,0xFFFD93F2,0xFFFD9E95,0xFFFDA8EA,0xFFFDB2F4,0xFFFDBCB7,0xFFFDC634,0xFFFDCF71,0xFFFDD86E,0xFFFDE130,
0xFFFDE9B8,0xFFFDF208,0xFFFDFA24,0xFFFE020C,0xFFFE09C4,0xFFFE114C,0xFFFE18A8,0xFFFE1FD7,0xFFFE26DD,0xFFFE2DBB,
0xFFFE3471,0xFFFE3B03,0xFFFE416F,0xFFFE47BA,0xFFFE4DE2,0xFFFE53EA,0xFFFE59D3,0xFFFE5F9D,0xFFFE654A,0xFFFE6ADA,
0xFFFE704F,0xFFFE75AA,0xFFFE7AEB,0xFFFE8013,0xFFFE8523,0xFFFE8A1B,0xFFFE8EFD,0xFFFE93C9,0xFFFE9880,0xFFFE9D22,
0xFFFEA1B0,0xFFFEA62B,0xFFFEAA93,0xFFFEAEE8,0xFFFEB32C,0xFFFEB75E,0xFFFEBB80,0xFFFEBF91,0xFFFEC392,0xFFFEC784,
0xFFFECB67,0xFFFECF3B,0xFFFED301,0xFFFED6B9,0xFFFEDA64,0xFFFEDE01,0xFFFEE192,0xFFFEE516,0xFFFEE88E,0xFFFEEBFA,
0xFFFEEF5B,0xFFFEF2B1,0xFFFEF5FB,0xFFFEF93B,0xFFFEFC71,0xFFFEFF9C,0xFFFF02BD,0xFFFF05D5,0xFFFF08E3,0xFFFF0BE8,
0xFFFF0EE4,0xFFFF11D7,0xFFFF14C2,0xFFFF17A4,0xFFFF1A7E,0xFFFF1D50,0xFFFF201B,0xFFFF22DD,0xFFFF2598,0xFFFF284C,
0xFFFF2AF9,0xFFFF2D9F,0xFFFF303E,0xFFFF32D6,0xFFFF3568,0xFFFF37F3,0xFFFF3A79,0xFFFF3CF8,0xFFFF3F71,0xFFFF41E4,
0xFFFF4452,0xFFFF46BA,0xFFFF491D,0xFFFF4B7A,0xFFFF4DD2,0xFFFF5025,0xFFFF5273,0xFFFF54BC,0xFFFF5700,0xFFFF5940,
0xFFFF5B7B,0xFFFF5DB2,0xFFFF5FE4,0xFFFF6212,0xFFFF643B,0xFFFF6661,0xFFFF6882,0xFFFF6AA0,0xFFFF6CB9,0xFFFF6ECF,
0xFFFF70E1,0xFFFF72F0,0xFFFF74FB,0xFFFF7702,0xFFFF7906,0xFFFF7B07,0xFFFF7D05,0xFFFF7EFF,0xFFFF80F6,0xFFFF82EA,
0xFFFF84DB,0xFFFF86CA,0xFFFF88B5,0xFFFF8A9E,0xFFFF8C83,0xFFFF8E66,0xFFFF9047,0xFFFF9225,0xFFFF9400,0xFFFF95D9,
0xFFFF97B0,0xFFFF9984,0xFFFF9B56,0xFFFF9D25,0xFFFF9EF3,0xFFFFA0BE,0xFFFFA287,0xFFFFA44F,0xFFFFA614,0xFFFFA7D7,
0xFFFFA998,0xFFFFAB58,0xFFFFAD15,0xFFFFAED1,0xFFFFB08B,0xFFFFB244,0xFFFFB3FB,0xFFFFB5B0,0xFFFFB763,0xFFFFB916,
0xFFFFBAC6,0xFFFFBC76,0xFFFFBE23,0xFFFFBFD0,0xFFFFC17B,0xFFFFC325,0xFFFFC4CE,0xFFFFC675,0xFFFFC81B,0xFFFFC9C0,
0xFFFFCB65,0xFFFFCD08,0xFFFFCEA9,0xFFFFD04A,0xFFFFD1EA,0xFFFFD38A,0xFFFFD528,0xFFFFD6C5,0xFFFFD862,0xFFFFD9FE,
0xFFFFDB99,0xFFFFDD33,0xFFFFDECC,0xFFFFE065,0xFFFFE1FE,0xFFFFE396,0xFFFFE52D,0xFFFFE6C3,0xFFFFE85A,0xFFFFE9EF,
0xFFFFEB85,0xFFFFED1A,0xFFFFEEAE,0xFFFFF042,0xFFFFF1D6,0xFFFFF36A,0xFFFFF4FD,0xFFFFF690,0xFFFFF823,0xFFFFF9B6,
0xFFFFFB49,0xFFFFFCDB,0xFFFFFE6E,0x00000000,
0};
const int acos_val[]={
0x0003243F,0x0003143C,0x00030D9A,0x00030882,0x00030436,0x0003006C,0x0002FCFF,0x0002F9D8,0x0002F6E9,0x0002F427,
0x0002F18B,0x0002EF0F,0x0002ECAF,0x0002EA68,0x0002E836,0x0002E618,0x0002E40C,0x0002E20F,0x0002E021,0x0002DE40,
0x0002DC6C,0x0002DAA3,0x0002D8E4,0x0002D72F,0x0002D584,0x0002D3E1,0x0002D246,0x0002D0B2,0x0002CF26,0x0002CDA1,
0x0002CC22,0x0002CAA9,0x0002C937,0x0002C7C9,0x0002C661,0x0002C4FE,0x0002C3A0,0x0002C247,0x0002C0F2,0x0002BFA1,
0x0002BE55,0x0002BD0C,0x0002BBC8,0x0002BA87,0x0002B949,0x0002B80F,0x0002B6D8,0x0002B5A5,0x0002B474,0x0002B347,
0x0002B21C,0x0002B0F5,0x0002AFD0,0x0002AEAD,0x0002AD8D,0x0002AC70,0x0002AB55,0x0002AA3D,0x0002A927,0x0002A813,
0x0002A701,0x0002A5F2,0x0002A4E4,0x0002A3D9,0x0002A2CF,0x0002A1C8,0x0002A0C2,0x00029FBE,0x00029EBC,0x00029DBC,
0x00029CBD,0x00029BC0,0x00029AC5,0x000299CB,0x000298D3,0x000297DD,0x000296E8,0x000295F4,0x00029502,0x00029411,
0x00029322,0x00029234,0x00029147,0x0002905C,0x00028F72,0x00028E89,0x00028DA2,0x00028CBC,0x00028BD7,0x00028AF3,
0x00028A10,0x0002892E,0x0002884E,0x0002876F,0x00028690,0x000285B3,0x000284D7,0x000283FC,0x00028321,0x00028248,
0x00028170,0x00028099,0x00027FC3,0x00027EED,0x00027E19,0x00027D45,0x00027C73,0x00027BA1,0x00027AD0,0x00027A00,
0x00027931,0x00027862,0x00027795,0x000276C8,0x000275FC,0x00027531,0x00027466,0x0002739D,0x000272D4,0x0002720C,
0x00027144,0x0002707D,0x00026FB7,0x00026EF2,0x00026E2D,0x00026D69,0x00026CA6,0x00026BE4,0x00026B22,0x00026A60,
0x000269A0,0x000268E0,0x00026820,0x00026761,0x000266A3,0x000265E6,0x00026529,0x0002646C,0x000263B0,0x000262F5,
0x0002623B,0x00026180,0x000260C7,0x0002600E,0x00025F55,0x00025E9D,0x00025DE6,0x00025D2F,0x00025C79,0x00025BC3,
0x00025B0E,0x00025A59,0x000259A4,0x000258F0,0x0002583D,0x0002578A,0x000256D8,0x00025626,0x00025574,0x000254C3,
0x00025413,0x00025362,0x000252B3,0x00025204,0x00025155,0x000250A6,0x00024FF8,0x00024F4B,0x00024E9E,0x00024DF1,
0x00024D45,0x00024C99,0x00024BED,0x00024B42,0x00024A97,0x000249ED,0x00024943,0x0002489A,0x000247F0,0x00024748,
0x0002469F,0x000245F7,0x00024550,0x000244A8,0x00024401,0x0002435B,0x000242B4,0x0002420E,0x00024169,0x000240C4,
0x0002401F,0x00023F7A,0x00023ED6,0x00023E32,0x00023D8E,0x00023CEB,0x00023C48,0x00023BA6,0x00023B03,0x00023A61,
0x000239C0,0x0002391E,0x0002387D,0x000237DC,0x0002373C,0x0002369C,0x000235FC,0x0002355C,0x000234BD,0x0002341E,
0x0002337F,0x000232E1,0x00023242,0x000231A4,0x00023107,0x00023069,0x00022FCC,0x00022F30,0x00022E93,0x00022DF7,
0x00022D5B,0x00022CBF,0x00022C23,0x00022B88,0x00022AED,0x00022A52,0x000229B8,0x0002291D,0x00022883,0x000227E9,
0x00022750,0x000226B7,0x0002261D,0x00022585,0x000224EC,0x00022454,0x000223BB,0x00022323,0x0002228C,0x000221F4,
0x0002215D,0x000220C6,0x0002202F,0x00021F98,0x00021F02,0x00021E6C,0x00021DD6,0x00021D40,0x00021CAA,0x00021C15,
0x00021B80,0x00021AEB,0x00021A56,0x000219C1,0x0002192D,0x00021899,0x00021805,0x00021771,0x000216DD,0x0002164A,
0x000215B7,0x00021524,0x00021491,0x000213FE,0x0002136C,0x000212D9,0x00021247,0x000211B5,0x00021123,0x00021092,
0x00021000,0x00020F6F,0x00020EDE,0x00020E4D,0x00020DBC,0x00020D2C,0x00020C9B,0x00020C0B,0x00020B7B,0x00020AEB,
0x00020A5B,0x000209CC,0x0002093C,0x000208AD,0x0002081E,0x0002078F,0x00020700,0x00020671,0x000205E3,0x00020555,
0x000204C6,0x00020438,0x000203AA,0x0002031D,0x0002028F,0x00020201,0x00020174,0x000200E7,0x0002005A,0x0001FFCD,
0x0001FF40,0x0001FEB3,0x0001FE27,0x0001FD9B,0x0001FD0E,0x0001FC82,0x0001FBF6,0x0001FB6A,0x0001FADF,0x0001FA53,
0x0001F9C8,0x0001F93C,0x0001F8B1,0x0001F826,0x0001F79B,0x0001F710,0x0001F686,0x0001F5FB,0x0001F570,0x0001F4E6,
0x0001F45C,0x0001F3D2,0x0001F348,0x0001F2BE,0x0001F234,0x0001F1AA,0x0001F121,0x0001F097,0x0001F00E,0x0001EF85,
0x0001EEFC,0x0001EE73,0x0001EDEA,0x0001ED61,0x0001ECD9,0x0001EC50,0x0001EBC8,0x0001EB3F,0x0001EAB7,0x0001EA2F,
0x0001E9A7,0x0001E91F,0x0001E897,0x0001E80F,0x0001E788,0x0001E700,0x0001E679,0x0001E5F1,0x0001E56A,0x0001E4E3,
0x0001E45C,0x0001E3D5,0x0001E34E,0x0001E2C7,0x0001E240,0x0001E1BA,0x0001E133,0x0001E0AD,0x0001E026,0x0001DFA0,
0x0001DF1A,0x0001DE94,0x0001DE0E,0x0001DD88,0x0001DD02,0x0001DC7C,0x0001DBF6,0x0001DB71,0x0001DAEB,0x0001DA66,
0x0001D9E1,0x0001D95B,0x0001D8D6,0x0001D851,0x0001D7CC,0x0001D747,0x0001D6C2,0x0001D63D,0x0001D5B8,0x0001D534,
0x0001D4AF,0x0001D42A,0x0001D3A6,0x0001D322,0x0001D29D,0x0001D219,0x0001D195,0x0001D111,0x0001D08D,0x0001D009,
0x0001CF85,0x0001CF01,0x0001CE7D,0x0001CDF9,0x0001CD76,0x0001CCF2,0x0001CC6E,0x0001CBEB,0x0001CB67,0x0001CAE4,
0x0001CA61,0x0001C9DE,0x0001C95A,0x0001C8D7,0x0001C854,0x0001C7D1,0x0001C74E,0x0001C6CB,0x0001C648,0x0001C5C6,
0x0001C543,0x0001C4C0,0x0001C43D,0x0001C3BB,0x0001C338,0x0001C2B6,0x0001C233,0x0001C1B1,0x0001C12F,0x0001C0AC,
0x0001C02A,0x0001BFA8,0x0001BF26,0x0001BEA4,0x0001BE22,0x0001BDA0,0x0001BD1E,0x0001BC9C,0x0001BC1A,0x0001BB98,
0x0001BB16,0x0001BA94,0x0001BA13,0x0001B991,0x0001B90F,0x0001B88E,0x0001B80C,0x0001B78B,0x0001B709,0x0001B688,
0x0001B606,0x0001B585,0x0001B504,0x0001B482,0x0001B401,0x0001B380,0x0001B2FF,0x0001B27D,0x0001B1FC,0x0001B17B,
0x0001B0FA,0x0001B079,0x0001AFF8,0x0001AF77,0x0001AEF6,0x0001AE75,0x0001ADF4,0x0001AD73,0x0001ACF2,0x0001AC72,
0x0001ABF1,0x0001AB70,0x0001AAEF,0x0001AA6F,0x0001A9EE,0x0001A96D,0x0001A8ED,0x0001A86C,0x0001A7EB,0x0001A76B,
0x0001A6EA,0x0001A66A,0x0001A5E9,0x0001A569,0x0001A4E8,0x0001A468,0x0001A3E7,0x0001A367,0x0001A2E6,0x0001A266,
0x0001A1E6,0x0001A165,0x0001A0E5,0x0001A065,0x00019FE4,0x00019F64,0x00019EE4,0x00019E63,0x00019DE3,0x00019D63,
0x00019CE3,0x00019C62,0x00019BE2,0x00019B62,0x00019AE2,0x00019A62,0x000199E1,0x00019961,0x000198E1,0x00019861,
0x000197E1,0x00019761,0x000196E0,0x00019660,0x000195E0,0x00019560,0x000194E0,0x00019460,0x000193E0,0x00019360,
0x000192DF,0x0001925F,0x000191DF,0x0001915F,0x000190DF,0x0001905F,0x00018FDF,0x00018F5F,0x00018EDE,0x00018E5E,
0x00018DDE,0x00018D5E,0x00018CDE,0x00018C5E,0x00018BDD,0x00018B5D,0x00018ADD,0x00018A5D,0x000189DD,0x0001895D,
0x000188DC,0x0001885C,0x000187DC,0x0001875C,0x000186DB,0x0001865B,0x000185DB,0x0001855B,0x000184DA,0x0001845A,
0x000183DA,0x00018359,0x000182D9,0x00018259,0x000181D8,0x00018158,0x000180D8,0x00018057,0x00017FD7,0x00017F56,
0x00017ED6,0x00017E55,0x00017DD5,0x00017D54,0x00017CD4,0x00017C53,0x00017BD2,0x00017B52,0x00017AD1,0x00017A50,
0x000179D0,0x0001794F,0x000178CE,0x0001784E,0x000177CD,0x0001774C,0x000176CB,0x0001764A,0x000175C9,0x00017548,
0x000174C7,0x00017446,0x000173C5,0x00017344,0x000172C3,0x00017242,0x000171C1,0x00017140,0x000170BF,0x0001703D,
0x00016FBC,0x00016F3B,0x00016EBA,0x00016E38,0x00016DB7,0x00016D35,0x00016CB4,0x00016C32,0x00016BB1,0x00016B2F,
0x00016AAD,0x00016A2C,0x000169AA,0x00016928,0x000168A7,0x00016825,0x000167A3,0x00016721,0x0001669F,0x0001661D,
0x0001659B,0x00016519,0x00016497,0x00016414,0x00016392,0x00016310,0x0001628D,0x0001620B,0x00016189,0x00016106,
0x00016084,0x00016001,0x00015F7E,0x00015EFC,0x00015E79,0x00015DF6,0x00015D73,0x00015CF0,0x00015C6D,0x00015BEA,
0x00015B67,0x00015AE4,0x00015A61,0x000159DE,0x0001595A,0x000158D7,0x00015854,0x000157D0,0x0001574C,0x000156C9,
0x00015645,0x000155C1,0x0001553E,0x000154BA,0x00015436,0x000153B2,0x0001532E,0x000152AA,0x00015225,0x000151A1,
0x0001511D,0x00015098,0x00015014,0x00014F8F,0x00014F0B,0x00014E86,0x00014E01,0x00014D7D,0x00014CF8,0x00014C73,
0x00014BEE,0x00014B68,0x00014AE3,0x00014A5E,0x000149D9,0x00014953,0x000148CE,0x00014848,0x000147C2,0x0001473D,
0x000146B7,0x00014631,0x000145AB,0x00014525,0x0001449E,0x00014418,0x00014392,0x0001430B,0x00014285,0x000141FE,
0x00014177,0x000140F1,0x0001406A,0x00013FE3,0x00013F5C,0x00013ED5,0x00013E4D,0x00013DC6,0x00013D3E,0x00013CB7,
0x00013C2F,0x00013BA8,0x00013B20,0x00013A98,0x00013A10,0x00013988,0x000138FF,0x00013877,0x000137EE,0x00013766,
0x000136DD,0x00013654,0x000135CC,0x00013543,0x000134B9,0x00013430,0x000133A7,0x0001331E,0x00013294,0x0001320A,
0x00013181,0x000130F7,0x0001306D,0x00012FE3,0x00012F58,0x00012ECE,0x00012E44,0x00012DB9,0x00012D2E,0x00012CA3,
0x00012C18,0x00012B8D,0x00012B02,0x00012A77,0x000129EB,0x00012960,0x000128D4,0x00012848,0x000127BC,0x00012730,
0x000126A4,0x00012617,0x0001258B,0x000124FE,0x00012472,0x000123E5,0x00012358,0x000122CA,0x0001223D,0x000121AF,
0x00012122,0x00012094,0x00012006,0x00011F78,0x00011EEA,0x00011E5B,0x00011DCD,0x00011D3E,0x00011CAF,0x00011C21,
0x00011B91,0x00011B02,0x00011A73,0x000119E3,0x00011953,0x000118C3,0x00011833,0x000117A3,0x00011713,0x00011682,
0x000115F1,0x00011560,0x000114CF,0x0001143E,0x000113AD,0x0001131B,0x00011289,0x000111F7,0x00011165,0x000110D3,
0x00011040,0x00010FAE,0x00010F1B,0x00010E88,0x00010DF4,0x00010D61,0x00010CCD,0x00010C3A,0x00010BA6,0x00010B11,
0x00010A7D,0x000109E8,0x00010954,0x000108BF,0x0001082A,0x00010794,0x000106FF,0x00010669,0x000105D3,0x0001053D,
0x000104A6,0x0001040F,0x00010379,0x000102E2,0x0001024A,0x000101B3,0x0001011B,0x00010083,0x0000FFEB,0x0000FF52,
0x0000FEBA,0x0000FE21,0x0000FD88,0x0000FCEF,0x0000FC55,0x0000FBBB,0x0000FB21,0x0000FA87,0x0000F9EC,0x0000F951,
0x0000F8B6,0x0000F81B,0x0000F780,0x0000F6E4,0x0000F648,0x0000F5AB,0x0000F50F,0x0000F472,0x0000F3D5,0x0000F338,
0x0000F29A,0x0000F1FC,0x0000F15E,0x0000F0BF,0x0000F021,0x0000EF82,0x0000EEE2,0x0000EE43,0x0000EDA3,0x0000ED03,
0x0000EC62,0x0000EBC1,0x0000EB20,0x0000EA7F,0x0000E9DD,0x0000E93B,0x0000E899,0x0000E7F6,0x0000E753,0x0000E6B0,
0x0000E60C,0x0000E569,0x0000E4C4,0x0000E420,0x0000E37B,0x0000E2D6,0x0000E230,0x0000E18A,0x0000E0E4,0x0000E03D,
0x0000DF96,0x0000DEEF,0x0000DE47,0x0000DD9F,0x0000DCF7,0x0000DC4E,0x0000DBA5,0x0000DAFB,0x0000DA51,0x0000D9A7,
0x0000D8FC,0x0000D851,0x0000D7A6,0x0000D6FA,0x0000D64D,0x0000D5A1,0x0000D4F4,0x0000D446,0x0000D398,0x0000D2EA,
0x0000D23B,0x0000D18C,0x0000D0DC,0x0000D02C,0x0000CF7B,0x0000CECA,0x0000CE19,0x0000CD67,0x0000CCB4,0x0000CC01,
0x0000CB4E,0x0000CA9A,0x0000C9E6,0x0000C931,0x0000C87C,0x0000C7C6,0x0000C70F,0x0000C658,0x0000C5A1,0x0000C4E9,
0x0000C431,0x0000C378,0x0000C2BE,0x0000C204,0x0000C149,0x0000C08E,0x0000BFD2,0x0000BF16,0x0000BE59,0x0000BD9B,
0x0000BCDD,0x0000BC1E,0x0000BB5F,0x0000BA9F,0x0000B9DE,0x0000B91D,0x0000B85B,0x0000B798,0x0000B6D5,0x0000B611,
0x0000B54C,0x0000B487,0x0000B3C1,0x0000B2FA,0x0000B233,0x0000B16B,0x0000B0A2,0x0000AFD8,0x0000AF0E,0x0000AE43,
0x0000AD77,0x0000ACAA,0x0000ABDC,0x0000AB0E,0x0000AA3F,0x0000A96F,0x0000A89E,0x0000A7CC,0x0000A6F9,0x0000A626,
0x0000A551,0x0000A47C,0x0000A3A6,0x0000A2CE,0x0000A1F6,0x0000A11D,0x0000A043,0x00009F68,0x00009E8B,0x00009DAE,
0x00009CD0,0x00009BF1,0x00009B10,0x00009A2E,0x0000994C,0x00009868,0x00009783,0x0000969C,0x000095B5,0x000094CC,
0x000093E2,0x000092F7,0x0000920A,0x0000911D,0x0000902D,0x00008F3D,0x00008E4A,0x00008D57,0x00008C62,0x00008B6B,
0x00008A73,0x0000897A,0x0000887E,0x00008781,0x00008683,0x00008583,0x00008480,0x0000837D,0x00008277,0x0000816F,
0x00008066,0x00007F5A,0x00007E4D,0x00007D3D,0x00007C2C,0x00007B18,0x00007A02,0x000078E9,0x000077CE,0x000076B1,
0x00007591,0x0000746F,0x0000734A,0x00007222,0x000070F8,0x00006FCA,0x00006E9A,0x00006D66,0x00006C2F,0x00006AF5,
0x000069B8,0x00006877,0x00006732,0x000065E9,0x0000649D,0x0000634C,0x000061F7,0x0000609E,0x00005F40,0x00005DDD,
0x00005C75,0x00005B08,0x00005995,0x0000581C,0x0000569E,0x00005518,0x0000538C,0x000051F9,0x0000505E,0x00004EBB,
0x00004D0F,0x00004B5A,0x0000499C,0x000047D3,0x000045FE,0x0000441D,0x0000422F,0x00004033,0x00003E26,0x00003C08,
0x000039D7,0x0000378F,0x00003530,0x000032B4,0x00003018,0x00002D56,0x00002A66,0x0000273F,0x000023D2,0x00002009,
0x00001BBD,0x000016A5,0x00001002,0x00000000,
0};

#endif
