const gDebugging = false;  // デバッグが終わったらfalseに
// const gDebugging = true;  // デバッグ中はtrueに

let 問題情報 = {
  問題数: 10*2,   // 最初は、たとえば  2*2 にしておく
  答えの最大値: 19, // 20未満の数の計算をする
  これまでに作った問題: [],
  問題カウンタ: 0,
  表示幅: "50rem",
  };

計算練習を表示();
document.keisanMondai.elements[0].focus(); // 最初の問題に移動

//計算練習のページを表示
function 計算練習を表示() {
  for (let i=0; i<問題情報.問題数; i++) {    // 問題の生成
    問題情報.これまでに作った問題[i] = 問題をひとつ生成(問題情報.答えの最大値);
  }

  // HTMLコードの生成
  // デバッグ時には、<table border="1"> とすると、線が引かれてわかりやすくなる
  let code = "";
  code +=  // 問題部分のコード
  `<form name="keisanMondai" action="">
    <table style="width: ${問題情報.表示幅}; margin: 0 auto;">
      <tr>
        <td>
          <table style="width: 100%;">
    `;
  
  for (let i=0; i<問題情報.問題数; i++) { // 問題ごとのループ
    code += `
      <tr>
        <td style="text-align: right;"> ${問題情報.これまでに作った問題[i]} </td>
        <td style="text-align: left;">＝ <input type="text" style="width: 5rem;"></td>
      </tr>
    `;
    if (i==問題情報.問題数/2-1) { //半分終わったときだけは、右の表に移るコードを追加
      code += '  </table>\n';  // 左の列の表の終わり
      code += '</td>\n';  // 外側の表の１つ目の要素の終わり
      code += '<td>\n';   // 外側の表の２つ目の要素の始まり
      code += '  <table width="100%">\n';
    }
  }
  code += '  </table>\n</td>\n</tr>\n</table>\n';
  //区切り線
  code += `
    <hr style="width: ${問題情報.表示幅}; text-align: center;">
    `;
  // 採点部分
  code += `
    <div id="scorePart" style="width: ${問題情報.表示幅};">
      <input id="doScoring" type="button" name="saiten" value="さいてん">
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; せいかい
      <input type="text" name="seikai" size="3" readonly="true">
      &nbsp;&nbsp;&nbsp;&nbsp; まちがい
      <input type="text" name="machigai" size="3" readonly="true">
      &nbsp;&nbsp;&nbsp;&nbsp;
      <input id="goToNextPage" type="button" name="again" value="つぎへ">
    </div>
    `;

  code += `
      </form>
    </table>
    `;

  document.getElementById("problems").innerHTML = code; // コードを出力
  document.getElementById("problems").style.width = 問題情報.表示幅;
  
  if (gDebugging) { // デバッグ用
    const デバッグ文字列 = `
      <form>
        <textarea name='debug' rows='20' cols='80'>
${code}
        </textarea>
      </form>
    `;
    document.getElementById("debugArea").innerHTML = デバッグ文字列;
  }
  
  // 解答などをクリア
  for (let i=0; i<問題情報.問題数; i++) { 
    document.keisanMondai.elements[i].value = "";
  }
  document.keisanMondai.seikai.value = "";
  document.keisanMondai.machigai.value = "";

  イベント処理を準備();
}

//採点をする
function 採点する() {
  let 正解数 = 0;
  let 誤答数 = 0;
  let f = document.keisanMondai; // form
  for (let i=0; i<問題情報.問題数; i++) {
    if (f.elements[i].value != "" &&
        f.elements[i].value == eval(問題情報.これまでに作った問題[i]) ) { // 正しい解
      f.elements[i].value += "　○";
      正解数++;
    }
    else {    // まちがい
      f.elements[i].value += "　×";
      誤答数++;
    }
  }
  f.seikai.value = 正解数;
  f.machigai.value = 誤答数;
  f.again.focus();
}

// 足し算か引き算をひとつ生成
// 引数  -- 問題情報.答えの最大値 （正数）
// 戻り値　-- 生成した問題。例 "1+1"
function 問題をひとつ生成(答えの最大値) {
  let no1;  // 第1項
  let no2;  // 第2項
  let 問題;
  let 演算子;  // "+" か "-" 


  // 「do ... while ループ」
  // 「do {文の列}  while (条件)」 は ともかく「文の列」を1回は実行して、最後に「条件」を判定する
  do {
    no1 = randomInt(答えの最大値-1);
    if (randomInt(2) == 1) { //足し算の場合
      演算子 = " + ";
      no2 = randomInt(答えの最大値-no1);
    }
    else {  // 引き算の場合
      演算子 = " - ";
      if (no1 > 10) {
        no2 = randomInt(no1-10);
      }
      else {
        no2 = randomInt(no1);
      }
    }
    問題 = no1 + 演算子 + no2; // 文字列として連結
  }
  while (問題重複チェック(問題)); // 重複している限り問題を作る。  「do ... while ループ」の条件判定

  return(問題); // 重複していなければ問題を返す
}


//これまでに生成した問題と重複があるかをチェックする
//引数   問題 -- チェック対象の問題。たとえば"1+1="
//戻り値 true  -- すでに生成した問題と重複していた
//       false -- 重複はなかった
function 問題重複チェック(問題) {
  for (let i=0; i<問題情報.問題カウンタ; i++) {
    if (問題情報.これまでに作った問題[i] == 問題) {
      return(true);
    }
  }
  問題情報.これまでに作った問題[問題情報.問題カウンタ] = 問題;
  問題情報.問題カウンタ++;
  return(false);
}


function イベント処理を準備() {
  // 「さいてん」ボタン
  document.getElementById("doScoring").addEventListener(
    "click",
    function() {
      採点する();
    })
  

  // 「つぎへ」ボタン。次の問題を表示
  document.getElementById("goToNextPage").addEventListener(
    "click",
    function() {
      location.reload();  // 再読み込みをして新しい問題を表示
    })
  
}


// 1以上i以下の整数を返す
function randomInt(i) {
  return( Math.floor(Math.random()*i) + 1 );
}
