<?php
//もし検索文字列が送られていなければ、検索できない
if (empty($_REQUEST['pref'])) {
  echo "<city>都道府県名が指定されていません</city>";
}
else {
  //検索対象の初めと終わりのホワイトスペースを取り除く
  $search = trim($_REQUEST['pref']);
  $cities = array();
  switch($search) {
  case "HO" :
    $cities [] = array(
		       'value' => 'sapporo',
		       'title' => "札幌");
    $cities [] = array(
		       'value' => 'asahikawa',
		       'title' => "旭川");
    break;
  case "FU" :
    $cities [] = array(
		       'value' => 'fukui',
		       'title' => "福井");
    $cities [] = array(
		       'value' => 'sabae',
		       'title' => "鯖江");
    $cities [] = array(
		       'value' => 'echizen',
		       'title' => "越前");
    break;
  case "NA" :
    $cities [] = array(
		       'value' => 'nagano',
		       'title' => "長野");
    $cities [] = array(
		       'value' => 'matsumoto',
		       'title' => "松本");
    $cities [] = array(
		       'value' => 'web3',
		       'title' => "Web 3.0 シティ");
    $cities [] = array(
		       'value' => 'ueda',
		       'title' => "上田");
    break;
  case "OK" :
    $cities [] = array(
		       'value' => 'naha',
		       'title' => "那覇");
    $cities [] = array(
		       'value' => 'ishigaki',
		       'title' => "石垣");
    break;
  default :
    $cities [] = array(
		       'value' => '',
		       'title' => "都市が見つかりません");
    break;
  }
  
  header("Content-Type: text/xml; charset=utf-8");
}

$doc = new DOMDocument();
$doc->formatOutput = false;

$r = $doc->createElement("cities");
$doc->appendChild( $r );

foreach ($cities as $city) {
  $c = $doc->createElement( "city" );

  $value  = $doc->createElement( "value" );
  $value->appendChild($doc->createTextNode($city['value']));
  $c->appendChild( $value );

  $title = $doc->createElement( "title" );
  $title->appendChild($doc->createTextNode($city['title']));
  $c->appendChild( $title );
  $r->appendChild( $c );
}
echo $doc->saveXML();
?>
