package com.androidbook.triviaquiz17;

//import java.io.DataInputStream;//原著（訳者注参照）
import java.io.BufferedReader;   //日本語対応版
import java.io.InputStreamReader;//日本語対応版

/* 【訳者注】
 原著ではDataInputStreamを使って
 
 DataInputStream dataIO = new DataInputStream(is);
 
 としているが、DataInputStream はビッグエンディアン用なので、Intelプロセッサでは
 多バイト文字が文字化けを起こす。
 多バイト文字に対応するにはBufferedReaderとInputStreamReaderを使って
 
 BufferedReader dataIO = new BufferedReader(new InputStreamReader(is));
 
 とすることが必要
 */

import java.io.IOException;
import java.io.InputStream;

import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

public class QuizHelpActivity extends QuizActivity {
    /** アクティビティが最初に生成されるときに呼び出される */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.help);
        // rawファイルから文字列に読み込んでTextViewの内容として設定する
        InputStream iFile = getResources().openRawResource(R.raw.quizhelp);
        try {
            TextView helpText = (TextView) findViewById(R.id.TextView_HelpText);
            String strFile = inputStreamToString(iFile);
            helpText.setText(strFile);
        } catch (Exception e) {
            Log.e(DEBUG_TAG, "inputStreamToStringのエラー", e);
        }
    }
    
    /**
     * 入力ストリームを文字列（String）に変換する
     * 
     * @param is
     *            読み込み元の {@code InputStream} オブジェクト
     *
     * @return 戻り値は入力された文字列に相当する {@code String} オブジェクト
     * @throws IOException
     *            入力の読み出しエラーの際に発行する
     */
    public String inputStreamToString(InputStream is) throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        // DataInputStream dataIO = new DataInputStream(is);
        BufferedReader dataIO = new BufferedReader(new InputStreamReader(is));
        // 訳者注参照
        String strLine = null;
        while ((strLine = dataIO.readLine()) != null) {
            sBuffer.append(strLine + "\n");
        }
        dataIO.close();
        is.close();
        return sBuffer.toString();
    }
}