package com.androidbook.triviaquiz7;

import android.content.Intent;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Animation.AnimationListener;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

// *** [Setting] -> [General] -> [Workspace] -> [Text file encoding] -> [UTF-8] ***
// 設定（環境設定）の[General] -> [Workspace] で [Text file encoding] を [UTF-8] に指定してください
//
public class QuizSplashActivity extends QuizActivity {
  /** アクティビティの最初の生成時に呼び出される */
  @Override
    public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.splash);
    startAnimating();
  }

  /**
   * スプラッシュスクリーンのアニメーションを開始する補助メソッド
   */
  private void startAnimating() {
    // 上部タイトルをフェードイン
    TextView logo1 = (TextView) findViewById(R.id.TextViewTopTitle);
    Animation fade1 = AnimationUtils.loadAnimation(this, R.anim.fade_in);
    logo1.startAnimation(fade1);
    // 下部タイトルを一定時間の遅れ（待ち）の後、フェードイン
    TextView logo2 = (TextView) findViewById(R.id.TextViewBottomTitle);
    Animation fade2 = AnimationUtils.loadAnimation(this, R.anim.fade_in2);
    logo2.startAnimation(fade2);
    // 下部タイトルのアニメーション終了後メインメニューに遷移する
    fade2.setAnimationListener(new AnimationListener() {
	public void onAnimationEnd(Animation animation) {
	  // アニメーションが終了したので、メインメニューに遷移する
	  startActivity(new Intent(QuizSplashActivity.this, QuizMenuActivity.class));
	  QuizSplashActivity.this.finish();
	}
	
	public void onAnimationRepeat(Animation animation) {
	}
	
	public void onAnimationStart(Animation animation) {
	}
      });
    // TableLayout内部の全ビュー用のアニメーションをロードする
    Animation spinin = AnimationUtils.loadAnimation(this, R.anim.custom_anim);
    LayoutAnimationController controller = new LayoutAnimationController(spinin);
    TableLayout table = (TableLayout) findViewById(R.id.TableLayout01);
    for (int i = 0; i < table.getChildCount(); i++) {
      TableRow row = (TableRow) table.getChildAt(i);
      row.setLayoutAnimation(controller);
    }
  }
  
  @Override
    protected void onPause() {
    super.onPause();
    // アニメーションを停止する
    TextView logo1 = (TextView) findViewById(R.id.TextViewTopTitle);
    logo1.clearAnimation();
    TextView logo2 = (TextView) findViewById(R.id.TextViewBottomTitle);
    logo2.clearAnimation();
    TableLayout table = (TableLayout) findViewById(R.id.TableLayout01);
    for (int i = 0; i < table.getChildCount(); i++) {
      TableRow row = (TableRow) table.getChildAt(i);
      row.clearAnimation();
    }
  }
  
  @Override
    protected void onResume() {
    super.onResume();
    
    // （起動時同様）スプラッシュスクリーン表示の全体が見られるように、最初のアニメーションを開始する
    startAnimating();
  }
}
