package com.androidbook.triviaquiz18;

import android.app.Activity;

public class QuizActivity extends Activity {
    
    // ゲームのプレファレンス用の文字列
    public static final String GAME_PREFERENCES = "GamePrefs";
    public static final String GAME_PREFERENCES_NICKNAME = "Nickname"; // String（ニックネーム）
    public static final String GAME_PREFERENCES_EMAIL = "Email"; // String（電子メール）
    public static final String GAME_PREFERENCES_PASSWORD = "Password"; // String（パスワード）
    public static final String GAME_PREFERENCES_DOB = "DOB"; // Long（生年月日）
    public static final String GAME_PREFERENCES_GENDER = "Gender"; // Integer（性別）
    // 性別は配列（array）の中では男性:1、女性:2、秘密:0で保存されている
    public static final String GAME_PREFERENCES_SCORE = "Score"; // Integer（スコア）
    public static final String GAME_PREFERENCES_CURRENT_QUESTION = "CurQuestion"; // Integer（現在の問題番号）
    public static final String GAME_PREFERENCES_AVATAR = "Avatar"; // String（アバター画像のURL）
    
    public static final String GAME_PREFERENCES_FAV_PLACE_NAME = "FavPlaceName"; // String（お気に入りの場所の名前）
    public static final String GAME_PREFERENCES_FAV_PLACE_LONG = "FavPlaceLong"; // float（お気に入りの場所の経度）
    public static final String GAME_PREFERENCES_FAV_PLACE_LAT = "FavPlaceLat"; // float（お気に入りの場所の緯度）
    
    public static final String GAME_PREFERENCES_PLAYER_ID = "ServerId"; // Integer（サーバーにアップロードするプレイヤーID）
    
    // XML Tag Names
    public static final String XML_TAG_QUESTION_BLOCK = "questions";
    public static final String XML_TAG_QUESTION = "question";
    public static final String XML_TAG_QUESTION_ATTRIBUTE_NUMBER = "number";
    public static final String XML_TAG_QUESTION_ATTRIBUTE_TEXT = "text";
    public static final String XML_TAG_QUESTION_ATTRIBUTE_IMAGEURL = "imageUrl";
    public static final int QUESTION_BATCH_SIZE = 5; // 15;
    
    // サーバーに関するURL
    public static final String TRIVIA_SERVER_BASE = "http://tqs.mamlambo.com/";
    public static final String TRIVIA_SERVER_SCORES = TRIVIA_SERVER_BASE + "scores.jsp";
    public static final String TRIVIA_SERVER_QUESTIONS = TRIVIA_SERVER_BASE + "questions.jsp";
    public static final String TRIVIA_SERVER_FRIEND_EDIT = TRIVIA_SERVER_BASE + "friend";
    public static final String TRIVIA_SERVER_ACCOUNT_EDIT = TRIVIA_SERVER_BASE + "receive";
    
    public static final String DEBUG_TAG = "Trivia Quiz Log";
}
