package com.androidbook.triviaquiz18;

import android.content.Intent;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Animation.AnimationListener;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class QuizSplashActivity extends QuizActivity {
    /** アクティビティが最初に生成されるときに呼び出される */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.splash);
        startAnimating();
    }
    
    /**
     * スプラッシュスクリーンのアニメーションを開始するためのヘルパーメソッド
     */
    private void startAnimating() {
        // 上部のタイトルをフェードイン
        TextView logo1 = (TextView) findViewById(R.id.TextViewTopTitle);
        Animation fade1 = AnimationUtils.loadAnimation(this, R.anim.fade_in);
        logo1.startAnimation(fade1);
        
        // 設定された遅延時間の後に下部のタイトルをフェードイン
        TextView logo2 = (TextView) findViewById(R.id.TextViewBottomTitle);
        Animation fade2 = AnimationUtils.loadAnimation(this, R.anim.fade_in2);
        logo2.startAnimation(fade2);
        
        // 下部タイトルのアニメーションが終了したらメインメニュー画面に移動
        fade2.setAnimationListener(new AnimationListener() {
            
            public void onAnimationEnd(Animation animation) {
                // アニメーションが終了したので、メインメニュー画面に移動
                startActivity(new Intent(QuizSplashActivity.this, QuizMenuActivity.class));
                QuizSplashActivity.this.finish();
            }
            
            public void onAnimationRepeat(Animation animation) {
            }
            
            public void onAnimationStart(Animation animation) {
            }
        });
        
        // TableLayoutコントロール内のすべてのビューに対してアニメーションを読み込み
        Animation spinin = AnimationUtils.loadAnimation(this, R.anim.custom_anim);
        LayoutAnimationController controller = new LayoutAnimationController(spinin);
        
        TableLayout table = (TableLayout) findViewById(R.id.TableLayout01);
        for (int i = 0; i < table.getChildCount(); i++) {
            TableRow row = (TableRow) table.getChildAt(i);
            row.setLayoutAnimation(controller);
        }
        
    }
    
    @Override
    protected void onPause() {
        super.onPause();
        // アニメーションを停止
        TextView logo1 = (TextView) findViewById(R.id.TextViewTopTitle);
        logo1.clearAnimation();
        
        TextView logo2 = (TextView) findViewById(R.id.TextViewBottomTitle);
        logo2.clearAnimation();
        
        TableLayout table = (TableLayout) findViewById(R.id.TableLayout01);
        for (int i = 0; i < table.getChildCount(); i++) {
            TableRow row = (TableRow) table.getChildAt(i);
            row.clearAnimation();
        }
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        
        // アニメーションを最初から開始して、スプラッシュスクリーンの動きの全体を見せる
        startAnimating();
    }
    
}
